/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.typesafe;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.discovery.ServiceURLSupplier;
import io.smallrye.graphql.client.impl.discovery.StaticURLSupplier;
import io.smallrye.graphql.client.impl.discovery.StorkServiceURLSupplier;
import io.smallrye.graphql.client.impl.typesafe.HeaderBuilder;
import io.smallrye.graphql.client.impl.typesafe.QueryBuilder;
import io.smallrye.graphql.client.impl.typesafe.ResultBuilder;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.vertx.websocket.BuiltinWebsocketSubprotocolHandlers;
import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class VertxTypesafeGraphQLClientProxy {
    private static final Logger log = Logger.getLogger(VertxTypesafeGraphQLClientProxy.class);
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private final ConcurrentMap<String, String> queryCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> additionalHeaders;
    private final ServiceURLSupplier endpoint;
    private final ServiceURLSupplier websocketUrl;
    private final HttpClient httpClient;
    private final WebClient webClient;
    private final List<WebsocketSubprotocol> subprotocols;
    private final Integer subscriptionInitializationTimeout;
    private final Class<?> api;
    private final boolean executeSingleOperationsOverWebsocket;
    private final AtomicReference<Uni<WebSocketSubprotocolHandler>> webSocketHandler = new AtomicReference();

    VertxTypesafeGraphQLClientProxy(Class<?> api, Map<String, String> additionalHeaders, URI endpoint, String websocketUrl, boolean executeSingleOperationsOverWebsocket, HttpClient httpClient, WebClient webClient, List<WebsocketSubprotocol> subprotocols, Integer subscriptionInitializationTimeout) {
        this.api = api;
        this.additionalHeaders = additionalHeaders;
        this.endpoint = endpoint != null ? (endpoint.getScheme().startsWith("stork") ? new StorkServiceURLSupplier(endpoint, false) : new StaticURLSupplier(endpoint.toString())) : null;
        this.websocketUrl = websocketUrl != null ? (websocketUrl.startsWith("stork") ? new StorkServiceURLSupplier(URI.create(websocketUrl), true) : new StaticURLSupplier(websocketUrl)) : null;
        this.executeSingleOperationsOverWebsocket = executeSingleOperationsOverWebsocket;
        this.httpClient = httpClient;
        this.webClient = webClient;
        this.subprotocols = subprotocols;
        this.subscriptionInitializationTimeout = subscriptionInitializationTimeout;
    }

    Object invoke(MethodInvocation method) {
        if (method.isDeclaredInObject()) {
            return method.invoke((Object)this);
        }
        MultiMap headers = HeadersMultiMap.headers().addAll(new HeaderBuilder(this.api, method, this.additionalHeaders).build());
        JsonObject request = this.request(method);
        if (method.getReturnType().isUni()) {
            if (this.executeSingleOperationsOverWebsocket) {
                return this.executeSingleResultOperationOverWebsocket(method, request);
            }
            return this.executeSingleResultOperationOverHttpAsync(method, request, headers);
        }
        if (method.getReturnType().isMulti()) {
            return this.executeSubscriptionOverWebsocket(method, request);
        }
        if (this.executeSingleOperationsOverWebsocket) {
            return this.executeSingleResultOperationOverWebsocket(method, request).await().indefinitely();
        }
        return this.executeSingleResultOperationOverHttpSync(method, request, headers);
    }

    private Object executeSingleResultOperationOverHttpSync(MethodInvocation method, JsonObject request, MultiMap headers) {
        HttpResponse<Buffer> response = this.postSync(request.toString(), headers);
        if (log.isTraceEnabled() && response != null) {
            log.tracef("response graphql: %s", (Object)response.bodyAsString());
        }
        return new ResultBuilder(method, response.bodyAsString(), Integer.valueOf(response.statusCode()), response.statusMessage()).read();
    }

    private Uni<Object> executeSingleResultOperationOverHttpAsync(MethodInvocation method, JsonObject request, MultiMap headers) {
        return Uni.createFrom().completionStage(this.postAsync(request.toString(), headers)).map(response -> new ResultBuilder(method, response.bodyAsString(), Integer.valueOf(response.statusCode()), response.statusMessage()).read());
    }

    private Uni<Object> executeSingleResultOperationOverWebsocket(MethodInvocation method, JsonObject request) {
        AtomicReference operationId = new AtomicReference();
        AtomicReference handlerRef = new AtomicReference();
        Uni rawUni = Uni.createFrom().emitter(rawEmitter -> this.webSocketHandler().subscribe().with(handler -> {
            handlerRef.set(handler);
            operationId.set(handler.executeUni(request, (UniEmitter<? super String>)rawEmitter));
        }));
        return rawUni.onCancellation().invoke(() -> {
            String id = (String)operationId.get();
            log.trace((Object)("Received onCancellation on operation ID " + id));
            if (id != null) {
                ((WebSocketSubprotocolHandler)handlerRef.get()).cancelMulti(id);
            } else {
                log.trace((Object)"Received onCancellation on an operation that does not have an ID yet");
            }
        }).onItem().transform(data -> {
            Object object = new ResultBuilder(method, data).read();
            if (object != null) {
                return object;
            }
            throw new InvalidResponseException("Couldn't find neither data nor errors in the response: " + data);
        });
    }

    private Multi<Object> executeSubscriptionOverWebsocket(MethodInvocation method, JsonObject request) {
        AtomicReference operationId = new AtomicReference();
        AtomicReference handlerRef = new AtomicReference();
        Multi rawMulti = Multi.createFrom().emitter(rawEmitter -> this.webSocketHandler().subscribe().with(handler -> {
            handlerRef.set(handler);
            operationId.set(handler.executeMulti(request, (MultiEmitter<? super String>)rawEmitter));
        }));
        return rawMulti.onCancellation().invoke(() -> ((WebSocketSubprotocolHandler)handlerRef.get()).cancelMulti((String)operationId.get())).onItem().transform(data -> {
            Object object = new ResultBuilder(method, data).read();
            if (object != null) {
                return object;
            }
            throw new InvalidResponseException("Couldn't find neither data nor errors in the response: " + data);
        });
    }

    private Uni<WebSocketSubprotocolHandler> webSocketHandler() {
        return this.webSocketHandler.updateAndGet(currentValue -> {
            if (currentValue == null) {
                return Uni.createFrom().emitter(handlerEmitter -> {
                    List subprotocolIds = this.subprotocols.stream().map(i -> i.getProtocolId()).collect(Collectors.toList());
                    MultiMap headers = HeadersMultiMap.headers().addAll(new HeaderBuilder(this.api, null, this.additionalHeaders).build());
                    this.websocketUrl.get().subscribe().with(wsUrl -> this.httpClient.webSocketAbs(wsUrl, headers, WebsocketVersion.V13, subprotocolIds, result -> {
                        if (result.succeeded()) {
                            WebSocket webSocket = (WebSocket)result.result();
                            WebSocketSubprotocolHandler handler = BuiltinWebsocketSubprotocolHandlers.createHandlerFor(webSocket.subProtocol(), webSocket, this.subscriptionInitializationTimeout, () -> this.webSocketHandler.set(null));
                            handlerEmitter.complete((Object)handler);
                            log.debug((Object)("Using websocket subprotocol handler: " + handler));
                        } else {
                            handlerEmitter.fail(result.cause());
                        }
                    }));
                }).memoize().indefinitely();
            }
            return currentValue;
        });
    }

    private JsonObject request(MethodInvocation method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        String query = this.queryCache.computeIfAbsent(method.getKey(), key -> new QueryBuilder(method).build());
        request.add("query", query);
        request.add("variables", this.variables(method));
        request.add("operationName", method.getName());
        JsonObject result = request.build();
        log.tracef("full graphql request: %s", (Object)result.toString());
        return result;
    }

    private JsonObjectBuilder variables(MethodInvocation method) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        method.valueParameters().forEach(parameter -> builder.add(parameter.getRawName(), this.value(parameter.getValue())));
        return builder;
    }

    private JsonValue value(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        TypeInfo type = TypeInfo.of(value.getClass());
        if (type.isScalar()) {
            return this.scalarValue(value);
        }
        if (type.isCollection()) {
            return this.arrayValue(value);
        }
        if (type.isMap()) {
            return this.mapValue(value);
        }
        return this.objectValue(value, type.fields());
    }

    private JsonValue scalarValue(Object value) {
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Date) {
            return Json.createValue((String)((Date)value).toInstant().toString());
        }
        if (value instanceof Enum) {
            return Json.createValue((String)((Enum)value).name());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value));
        }
        return Json.createValue((String)value.toString());
    }

    private JsonArray arrayValue(Object value) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.values(value).forEach(item -> array.add(this.value(item)));
        return array.build();
    }

    private JsonArray mapValue(Object value) {
        Map map = (Map)value;
        JsonArrayBuilder array = Json.createArrayBuilder();
        map.forEach((k, v) -> {
            JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
            entryBuilder.add("key", this.value(k));
            entryBuilder.add("value", this.value(v));
            array.add((JsonValue)entryBuilder.build());
        });
        return array.build();
    }

    private Collection<?> values(Object value) {
        return value.getClass().isArray() ? this.array(value) : (List<Object>)value;
    }

    private List<Object> array(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return this.primitiveArray(value);
        }
        return Arrays.asList((Object[])value);
    }

    private List<Object> primitiveArray(Object value) {
        int length = Array.getLength(value);
        ArrayList<Object> out = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            out.add(Array.get(value, i));
        }
        return out;
    }

    private JsonObject objectValue(Object object, Stream<FieldInfo> fields) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        fields.forEach(field -> {
            if (field.isIncludeNull() || field.get(object) != null) {
                builder.add(field.getName(), this.value(field.get(object)));
            }
        });
        return builder.build();
    }

    private CompletionStage<HttpResponse<Buffer>> postAsync(String request, MultiMap headers) {
        return this.endpoint.get().subscribeAsCompletionStage().thenCompose(url -> this.webClient.postAbs(url).putHeaders(headers).sendBuffer(Buffer.buffer((String)request)).toCompletionStage());
    }

    private HttpResponse<Buffer> postSync(String request, MultiMap headers) {
        Future future = this.webClient.postAbs((String)this.endpoint.get().await().indefinitely()).putHeaders(headers).sendBuffer(Buffer.buffer((String)request));
        try {
            return (HttpResponse)future.toCompletionStage().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Request failed", e);
        }
    }

    void close() {
        try {
            this.httpClient.close();
        }
        catch (Throwable t) {
            log.warn((Object)t);
        }
        try {
            this.webClient.close();
        }
        catch (Throwable t) {
            log.warn((Object)t);
        }
    }
}

