/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.dynamic;

import io.smallrye.graphql.client.Request;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.core.Document;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.impl.RequestImpl;
import io.smallrye.graphql.client.impl.ResponseReader;
import io.smallrye.graphql.client.impl.discovery.ServiceURLSupplier;
import io.smallrye.graphql.client.impl.discovery.StaticURLSupplier;
import io.smallrye.graphql.client.impl.discovery.StorkServiceURLSupplier;
import io.smallrye.graphql.client.vertx.websocket.BuiltinWebsocketSubprotocolHandlers;
import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import jakarta.json.JsonObject;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class VertxDynamicGraphQLClient
implements DynamicGraphQLClient {
    private static final Logger log = Logger.getLogger(VertxDynamicGraphQLClient.class);
    private final WebClient webClient;
    private final HttpClient httpClient;
    private final ServiceURLSupplier url;
    private final ServiceURLSupplier websocketUrl;
    private final boolean executeSingleOperationsOverWebsocket;
    private final MultiMap headers;
    private final List<WebsocketSubprotocol> subprotocols;
    private final Integer subscriptionInitializationTimeout;
    private final AtomicReference<Uni<WebSocketSubprotocolHandler>> webSocketHandler = new AtomicReference();

    VertxDynamicGraphQLClient(Vertx vertx, WebClient webClient, String url, String websocketUrl, boolean executeSingleOperationsOverWebsocket, MultiMap headers, WebClientOptions options, List<WebsocketSubprotocol> subprotocols, Integer subscriptionInitializationTimeout) {
        this.httpClient = options != null ? vertx.createHttpClient((HttpClientOptions)options) : vertx.createHttpClient();
        this.webClient = webClient == null ? WebClient.wrap((HttpClient)this.httpClient) : webClient;
        this.headers = headers;
        this.url = url != null ? (url.startsWith("stork") ? new StorkServiceURLSupplier(URI.create(url), false) : new StaticURLSupplier(url)) : null;
        this.websocketUrl = websocketUrl != null ? (websocketUrl.startsWith("stork") ? new StorkServiceURLSupplier(URI.create(websocketUrl), true) : new StaticURLSupplier(websocketUrl)) : null;
        this.executeSingleOperationsOverWebsocket = executeSingleOperationsOverWebsocket;
        this.subprotocols = subprotocols;
        this.subscriptionInitializationTimeout = subscriptionInitializationTimeout;
    }

    public Response executeSync(Document document) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, null).toJsonObject());
    }

    public Response executeSync(Document document, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, null).toJsonObject());
    }

    public Response executeSync(Document document, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, operationName).toJsonObject());
    }

    public Response executeSync(Document document, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, operationName).toJsonObject());
    }

    public Response executeSync(Request request) throws ExecutionException, InterruptedException {
        return this.executeSync(request.toJsonObject());
    }

    public Response executeSync(String query) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(query, null, null).toJsonObject());
    }

    public Response executeSync(String query, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(query, variables, null).toJsonObject());
    }

    public Response executeSync(String query, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(query, null, operationName).toJsonObject());
    }

    public Response executeSync(String query, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(query, variables, operationName).toJsonObject());
    }

    private Response executeSync(JsonObject json) {
        if (this.executeSingleOperationsOverWebsocket) {
            return (Response)this.executeSingleResultOperationOverWebsocket(json).await().indefinitely();
        }
        return (Response)this.executeSingleResultOperationOverHttp(json).await().indefinitely();
    }

    private Map<String, List<String>> convertHeaders(MultiMap input) {
        return input.entries().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public Uni<Response> executeAsync(Document document) {
        return this.executeAsync(this.buildRequest(document, null, null));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables) {
        return this.executeAsync(this.buildRequest(document, variables, null));
    }

    public Uni<Response> executeAsync(Document document, String operationName) {
        return this.executeAsync(this.buildRequest(document, null, operationName));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables, String operationName) {
        return this.executeAsync(this.buildRequest(document, variables, operationName));
    }

    public Uni<Response> executeAsync(Request request) {
        return this.executeAsync(request.toJsonObject());
    }

    public Uni<Response> executeAsync(String query) {
        return this.executeAsync(this.buildRequest(query, null, null).toJsonObject());
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables) {
        return this.executeAsync(this.buildRequest(query, variables, null).toJsonObject());
    }

    public Uni<Response> executeAsync(String query, String operationName) {
        return this.executeAsync(this.buildRequest(query, null, operationName).toJsonObject());
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables, String operationName) {
        return this.executeAsync(this.buildRequest(query, variables, operationName).toJsonObject());
    }

    private Uni<Response> executeAsync(JsonObject json) {
        if (this.executeSingleOperationsOverWebsocket) {
            return this.executeSingleResultOperationOverWebsocket(json);
        }
        return this.executeSingleResultOperationOverHttp(json);
    }

    public Multi<Response> subscription(Document document) {
        return this.subscription0(this.buildRequest(document, null, null).toJsonObject());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(document, variables, null).toJsonObject());
    }

    public Multi<Response> subscription(Document document, String operationName) {
        return this.subscription0(this.buildRequest(document, null, operationName).toJsonObject());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(document, variables, operationName).toJsonObject());
    }

    public Multi<Response> subscription(Request request) {
        return this.subscription0(request.toJsonObject());
    }

    public Multi<Response> subscription(String query) {
        return this.subscription0(this.buildRequest(query, null, null).toJsonObject());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(query, variables, null).toJsonObject());
    }

    public Multi<Response> subscription(String query, String operationName) {
        return this.subscription0(this.buildRequest(query, null, operationName).toJsonObject());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(query, variables, operationName).toJsonObject());
    }

    private Multi<Response> subscription0(JsonObject json) {
        return this.executeSubscriptionOverWebsocket(json);
    }

    private Request buildRequest(Document document, Map<String, Object> variables, String operationName) {
        return this.buildRequest(document.build(), variables, operationName);
    }

    private Request buildRequest(String query, Map<String, Object> variables, String operationName) {
        RequestImpl request = new RequestImpl(query);
        if (variables != null) {
            request.setVariables(variables);
        }
        if (operationName != null && !operationName.isEmpty()) {
            request.setOperationName(operationName);
        }
        return request;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Throwable t) {
            log.warn((Object)t);
        }
        try {
            this.webClient.close();
        }
        catch (Throwable t) {
            log.warn((Object)t);
        }
    }

    private Uni<WebSocketSubprotocolHandler> webSocketHandler() {
        return this.webSocketHandler.updateAndGet(currentValue -> {
            if (currentValue == null) {
                return Uni.createFrom().emitter(handlerEmitter -> {
                    List subprotocolIds = this.subprotocols.stream().map(i -> i.getProtocolId()).collect(Collectors.toList());
                    this.websocketUrl.get().subscribe().with(websocketUrl -> this.httpClient.webSocketAbs(websocketUrl, this.headers, WebsocketVersion.V13, subprotocolIds, result -> {
                        if (result.succeeded()) {
                            WebSocket webSocket = (WebSocket)result.result();
                            WebSocketSubprotocolHandler handler = BuiltinWebsocketSubprotocolHandlers.createHandlerFor(webSocket.subProtocol(), webSocket, this.subscriptionInitializationTimeout, () -> this.webSocketHandler.set(null));
                            handlerEmitter.complete((Object)handler);
                            log.debug((Object)("Using websocket subprotocol handler: " + handler));
                        } else {
                            handlerEmitter.fail(result.cause());
                        }
                    }));
                }).memoize().indefinitely();
            }
            return currentValue;
        });
    }

    private Uni<Response> executeSingleResultOperationOverHttp(JsonObject json) {
        return Uni.createFrom().completionStage(this.url.get().subscribeAsCompletionStage().thenCompose(instanceUrl -> this.webClient.postAbs(instanceUrl).putHeaders(this.headers).sendBuffer(Buffer.buffer((String)json.toString())).toCompletionStage())).map(response -> ResponseReader.readFrom((String)response.bodyAsString(), this.convertHeaders(response.headers())));
    }

    private Uni<Response> executeSingleResultOperationOverWebsocket(JsonObject json) {
        AtomicReference operationId = new AtomicReference();
        AtomicReference handlerRef = new AtomicReference();
        Uni rawUni = Uni.createFrom().emitter(rawEmitter -> this.webSocketHandler().subscribe().with(handler -> {
            handlerRef.set(handler);
            operationId.set(handler.executeUni(json, (UniEmitter<? super String>)rawEmitter));
        }));
        return rawUni.onCancellation().invoke(() -> {
            String id = (String)operationId.get();
            log.trace((Object)("Received onCancellation on operation ID " + id));
            if (id != null) {
                ((WebSocketSubprotocolHandler)handlerRef.get()).cancelUni(id);
            } else {
                log.trace((Object)"Received onCancellation on an operation that does not have an ID yet");
            }
        }).onItem().transform(data -> ResponseReader.readFrom((String)data, Collections.emptyMap()));
    }

    private Multi<Response> executeSubscriptionOverWebsocket(JsonObject json) {
        AtomicReference operationId = new AtomicReference();
        AtomicReference handlerRef = new AtomicReference();
        Multi rawMulti = Multi.createFrom().emitter(rawEmitter -> this.webSocketHandler().subscribe().with(handler -> {
            handlerRef.set(handler);
            operationId.set(handler.executeMulti(json, (MultiEmitter<? super String>)rawEmitter));
        }));
        return rawMulti.onCancellation().invoke(() -> {
            String id = (String)operationId.get();
            log.trace((Object)("Received onCancellation on operation ID " + id));
            if (id != null) {
                ((WebSocketSubprotocolHandler)handlerRef.get()).cancelMulti(id);
            } else {
                log.trace((Object)"Received onCancellation on an operation that does not have an ID yet");
            }
        }).onItem().transform(data -> ResponseReader.readFrom((String)data, Collections.emptyMap()));
    }
}

