/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.typesafe;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.impl.typesafe.HeaderBuilder;
import io.smallrye.graphql.client.impl.typesafe.QueryBuilder;
import io.smallrye.graphql.client.impl.typesafe.ResultBuilder;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.vertx.websocket.BuiltinWebsocketSubprotocolHandlers;
import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jboss.logging.Logger;

class VertxTypesafeGraphQLClientProxy {
    private static final Logger log = Logger.getLogger(VertxTypesafeGraphQLClientProxy.class);
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private final Map<String, String> queryCache = new HashMap<String, String>();
    private final Map<String, String> additionalHeaders;
    private final URI endpoint;
    private final HttpClient httpClient;
    private final WebClient webClient;
    private final List<WebsocketSubprotocol> subprotocols;
    private final Integer subscriptionInitializationTimeout;

    VertxTypesafeGraphQLClientProxy(Map<String, String> additionalHeaders, URI endpoint, HttpClient httpClient, WebClient webClient, List<WebsocketSubprotocol> subprotocols, Integer subscriptionInitializationTimeout) {
        this.additionalHeaders = additionalHeaders;
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.webClient = webClient;
        this.subprotocols = subprotocols;
        this.subscriptionInitializationTimeout = subscriptionInitializationTimeout;
    }

    Object invoke(Class<?> api, MethodInvocation method) {
        if (method.isDeclaredInObject()) {
            return method.invoke((Object)this);
        }
        MultiMap headers = HeadersMultiMap.headers().addAll(new HeaderBuilder(api, method, this.additionalHeaders).build());
        JsonObject request = this.request(method);
        if (method.getReturnType().isUni()) {
            return Uni.createFrom().completionStage(this.postAsync(request.toString(), headers)).map(response -> new ResultBuilder(method, response.bodyAsString()).read());
        }
        if (method.getReturnType().isMulti()) {
            String WSURL = this.endpoint.toString().replaceFirst("http", "ws");
            List subprotocolIds = this.subprotocols.stream().map(i -> i.getProtocolId()).collect(Collectors.toList());
            AtomicReference handlerReference = new AtomicReference();
            return Multi.createFrom().emitter(emitter -> this.httpClient.webSocketAbs(WSURL, headers, WebsocketVersion.V13, subprotocolIds, result -> {
                if (result.succeeded()) {
                    WebSocket webSocket = (WebSocket)result.result();
                    WebSocketSubprotocolHandler handler = BuiltinWebsocketSubprotocolHandlers.createHandlerFor(webSocket.subProtocol(), this.subscriptionInitializationTimeout);
                    handlerReference.set(handler);
                    log.debug((Object)("Using websocket subprotocol handler: " + handler));
                    Multi rawData = Multi.createFrom().emitter(rawEmitter -> handler.handleWebSocketStart(request, (MultiEmitter<? super String>)rawEmitter, webSocket));
                    rawData.subscribe().with(data -> {
                        block4: {
                            try {
                                Object item = new ResultBuilder(method, data).read();
                                if (item != null) {
                                    emitter.emit(item);
                                } else {
                                    emitter.complete();
                                }
                            }
                            catch (GraphQLClientException ex) {
                                if (emitter.isCancelled()) break block4;
                                emitter.fail((Throwable)ex);
                            }
                        }
                    }, failure -> emitter.fail(failure), () -> emitter.complete());
                } else {
                    emitter.fail(result.cause());
                }
            })).onTermination().invoke(() -> {
                WebSocketSubprotocolHandler handler = (WebSocketSubprotocolHandler)handlerReference.get();
                if (handler != null) {
                    handler.handleCancel();
                }
            });
        }
        String response2 = this.postSync(request.toString(), headers);
        log.debugf("response graphql: %s", (Object)response2);
        return new ResultBuilder(method, response2).read();
    }

    private JsonObject request(MethodInvocation method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        String query = this.queryCache.computeIfAbsent(method.getKey(), key -> new QueryBuilder(method).build());
        request.add("query", query);
        request.add("variables", this.variables(method));
        request.add("operationName", method.getName());
        log.debugf("request graphql: %s", (Object)query);
        JsonObject result = request.build();
        log.debugf("full graphql request: %s", (Object)result.toString());
        return result;
    }

    private JsonObjectBuilder variables(MethodInvocation method) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        method.valueParameters().forEach(parameter -> builder.add(parameter.getRawName(), this.value(parameter.getValue())));
        return builder;
    }

    private JsonValue value(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        TypeInfo type = TypeInfo.of(value.getClass());
        if (type.isScalar()) {
            return this.scalarValue(value);
        }
        if (type.isCollection()) {
            return this.arrayValue(value);
        }
        if (type.isMap()) {
            return this.mapValue(value);
        }
        return this.objectValue(value, type.fields());
    }

    private JsonValue scalarValue(Object value) {
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Date) {
            return Json.createValue((String)((Date)value).toInstant().toString());
        }
        if (value instanceof Enum) {
            return Json.createValue((String)((Enum)value).name());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value));
        }
        return Json.createValue((String)value.toString());
    }

    private JsonArray arrayValue(Object value) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.values(value).forEach(item -> array.add(this.value(item)));
        return array.build();
    }

    private JsonArray mapValue(Object value) {
        Map map = (Map)value;
        JsonArrayBuilder array = Json.createArrayBuilder();
        map.forEach((k, v) -> {
            JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
            entryBuilder.add("key", this.value(k));
            entryBuilder.add("value", this.value(v));
            array.add((JsonValue)entryBuilder.build());
        });
        return array.build();
    }

    private Collection<?> values(Object value) {
        return value.getClass().isArray() ? this.array(value) : (List<Object>)value;
    }

    private List<Object> array(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return this.primitiveArray(value);
        }
        return Arrays.asList((Object[])value);
    }

    private List<Object> primitiveArray(Object value) {
        int length = Array.getLength(value);
        ArrayList<Object> out = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            out.add(Array.get(value, i));
        }
        return out;
    }

    private JsonObject objectValue(Object object, Stream<FieldInfo> fields) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        fields.forEach(field -> {
            if (field.isIncludeNull() || field.get(object) != null) {
                builder.add(field.getName(), this.value(field.get(object)));
            }
        });
        return builder.build();
    }

    private CompletionStage<HttpResponse<Buffer>> postAsync(String request, MultiMap headers) {
        return this.webClient.postAbs(this.endpoint.toString()).putHeaders(headers).sendBuffer(Buffer.buffer((String)request)).toCompletionStage();
    }

    private String postSync(String request, MultiMap headers) {
        Future future = this.webClient.postAbs(this.endpoint.toString()).putHeaders(headers).sendBuffer(Buffer.buffer((String)request));
        try {
            HttpResponse result = (HttpResponse)future.toCompletionStage().toCompletableFuture().get();
            if (result.statusCode() != 200) {
                throw new RuntimeException("expected successful status code but got " + result.statusCode() + " " + result.statusMessage() + ":\n" + result.bodyAsString());
            }
            return result.bodyAsString();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Request failed", e);
        }
    }

    void close() {
        try {
            this.httpClient.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.webClient.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

