/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.typesafe;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.impl.typesafe.HeaderBuilder;
import io.smallrye.graphql.client.impl.typesafe.QueryBuilder;
import io.smallrye.graphql.client.impl.typesafe.ResultBuilder;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jboss.logging.Logger;

class VertxTypesafeGraphQLClientProxy {
    private static final Logger log = Logger.getLogger(VertxTypesafeGraphQLClientProxy.class);
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private final Map<String, String> queryCache = new HashMap<String, String>();
    private final Map<String, String> additionalHeaders;
    private final URI endpoint;
    private final HttpClient httpClient;
    private final WebClient webClient;

    VertxTypesafeGraphQLClientProxy(Map<String, String> additionalHeaders, URI endpoint, HttpClient httpClient, WebClient webClient) {
        this.additionalHeaders = additionalHeaders;
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.webClient = webClient;
    }

    Object invoke(Class<?> api, MethodInvocation method) {
        if (method.isDeclaredInObject()) {
            return method.invoke((Object)this);
        }
        MultiMap headers = HeadersMultiMap.headers().addAll(new HeaderBuilder(api, method, this.additionalHeaders).build());
        String request = this.request(method);
        if (method.getReturnType().isUni()) {
            return Uni.createFrom().completionStage(this.postAsync(request, headers)).map(response -> new ResultBuilder(method, response.bodyAsString()).read());
        }
        if (method.getReturnType().isMulti()) {
            String WSURL = this.endpoint.toString().replaceFirst("http", "ws");
            return Multi.createFrom().emitter(emitter -> this.httpClient.webSocketAbs(WSURL, headers, WebsocketVersion.V13, new ArrayList(), result -> this.handleMultiResult(method, request, (MultiEmitter<? super Object>)emitter, (AsyncResult<WebSocket>)result)));
        }
        String response2 = this.postSync(request, headers);
        log.debugf("response graphql: %s", (Object)response2);
        return new ResultBuilder(method, response2).read();
    }

    private String request(MethodInvocation method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        String query = this.queryCache.computeIfAbsent(method.getKey(), key -> new QueryBuilder(method).build());
        request.add("query", query);
        request.add("variables", this.variables(method));
        request.add("operationName", method.getName());
        log.debugf("request graphql: %s", (Object)query);
        String requestString = request.build().toString();
        log.debugf("full graphql request: %s", (Object)requestString);
        return requestString;
    }

    private JsonObjectBuilder variables(MethodInvocation method) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        method.valueParameters().forEach(parameter -> builder.add(parameter.getRawName(), this.value(parameter.getValue())));
        return builder;
    }

    private JsonValue value(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        TypeInfo type = TypeInfo.of(value.getClass());
        if (type.isScalar()) {
            return this.scalarValue(value);
        }
        if (type.isCollection()) {
            return this.arrayValue(value);
        }
        if (type.isMap()) {
            return this.mapValue(value);
        }
        return this.objectValue(value, type.fields());
    }

    private JsonValue scalarValue(Object value) {
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Date) {
            return Json.createValue((String)((Date)value).toInstant().toString());
        }
        if (value instanceof Enum) {
            return Json.createValue((String)((Enum)value).name());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value));
        }
        return Json.createValue((String)value.toString());
    }

    private JsonArray arrayValue(Object value) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.values(value).forEach(item -> array.add(this.value(item)));
        return array.build();
    }

    private JsonArray mapValue(Object value) {
        Map map = (Map)value;
        JsonArrayBuilder array = Json.createArrayBuilder();
        map.forEach((k, v) -> {
            JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
            entryBuilder.add("key", this.value(k));
            entryBuilder.add("value", this.value(v));
            array.add((JsonValue)entryBuilder.build());
        });
        return array.build();
    }

    private Collection<?> values(Object value) {
        return value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
    }

    private JsonObject objectValue(Object object, Stream<FieldInfo> fields) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        fields.forEach(field -> {
            if (field.isIncludeNull() || field.get(object) != null) {
                builder.add(field.getName(), this.value(field.get(object)));
            }
        });
        return builder.build();
    }

    private CompletionStage<HttpResponse<Buffer>> postAsync(String request, MultiMap headers) {
        return this.webClient.postAbs(this.endpoint.toString()).putHeaders(headers).sendBuffer(Buffer.buffer((String)request)).toCompletionStage();
    }

    private void handleMultiResult(MethodInvocation method, String request, MultiEmitter<? super Object> emitter, AsyncResult<WebSocket> result) {
        if (result.succeeded()) {
            WebSocket socket = (WebSocket)result.result();
            socket.writeTextMessage(request);
            socket.handler(message -> {
                block5: {
                    if (!emitter.isCancelled()) {
                        try {
                            Object item = new ResultBuilder(method, message.toString()).read();
                            if (item != null) {
                                emitter.emit(item);
                                break block5;
                            }
                            emitter.complete();
                        }
                        catch (GraphQLClientException ex) {
                            if (!emitter.isCancelled()) {
                                emitter.fail((Throwable)ex);
                            }
                            break block5;
                        }
                    }
                    log.warn((Object)"Received an additional item for a subscription that has already ended with a failure, dropping it.");
                }
            });
            socket.closeHandler(v -> emitter.complete());
            emitter.onTermination(() -> ((WebSocket)socket).close());
        } else {
            emitter.fail(result.cause());
        }
    }

    private String postSync(String request, MultiMap headers) {
        Future future = this.webClient.postAbs(this.endpoint.toString()).putHeaders(headers).sendBuffer(Buffer.buffer((String)request));
        try {
            HttpResponse result = (HttpResponse)future.toCompletionStage().toCompletableFuture().get();
            if (result.statusCode() != 200) {
                throw new RuntimeException("expected successful status code but got " + result.statusCode() + " " + result.statusMessage() + ":\n" + result.bodyAsString());
            }
            return result.bodyAsString();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Request failed", e);
        }
    }

    void close() {
        try {
            this.httpClient.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.webClient.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

