/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.typesafe;

import io.smallrye.graphql.client.impl.ErrorMessageProvider;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.vertx.typesafe.VertxTypesafeGraphQLClientProxy;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClient;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.Map;

public class VertxTypesafeGraphQLClientBuilder
implements TypesafeGraphQLClientBuilder {
    private static Vertx VERTX;
    private String configKey = null;
    private URI endpoint;
    private Map<String, String> headers;
    private Vertx vertx;
    private HttpClientOptions options;
    private WebClient webClient;
    private HttpClient httpClient;

    public TypesafeGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public TypesafeGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public TypesafeGraphQLClientBuilder client(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    public TypesafeGraphQLClientBuilder options(HttpClientOptions options) {
        this.options = options;
        return this;
    }

    public TypesafeGraphQLClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TypesafeGraphQLClientBuilder header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        if (this.configKey == null) {
            this.configKey = this.configKey(apiClass);
        }
        this.applyConfigFor(apiClass);
        if (this.endpoint == null) {
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        this.initClients();
        VertxTypesafeGraphQLClientProxy graphQlClient = new VertxTypesafeGraphQLClientProxy(this.headers, this.endpoint, this.httpClient, this.webClient);
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> this.invoke(apiClass, graphQlClient, method, args)));
    }

    private void applyConfigFor(Class<?> apiClass) {
        GraphQLClientsConfiguration configs = GraphQLClientsConfiguration.getInstance();
        configs.initTypesafeClientApi(apiClass);
        GraphQLClientConfiguration persistentConfig = configs.getClient(this.configKey);
        if (persistentConfig != null) {
            this.applyConfig(persistentConfig);
        }
    }

    private void initClients() {
        if (this.webClient == null) {
            if (this.httpClient == null) {
                this.httpClient = this.options != null ? this.vertx().createHttpClient(this.options) : this.vertx().createHttpClient();
            }
            this.webClient = WebClient.wrap((HttpClient)this.httpClient);
        } else if (this.httpClient == null) {
            this.httpClient = this.options != null ? this.vertx().createHttpClient(this.options) : this.vertx().createHttpClient();
        }
    }

    private Vertx vertx() {
        if (this.vertx == null) {
            Context vertxContext = Vertx.currentContext();
            if (vertxContext != null && vertxContext.owner() != null) {
                this.vertx = vertxContext.owner();
            } else {
                if (VERTX == null) {
                    VERTX = Vertx.vertx();
                }
                this.vertx = VERTX;
            }
        }
        return this.vertx;
    }

    private Object invoke(Class<?> apiClass, VertxTypesafeGraphQLClientProxy graphQlClient, Method method, Object ... args) {
        MethodInvocation methodInvocation = MethodInvocation.of((Method)method, (Object[])args);
        if (methodInvocation.isDeclaredInCloseable()) {
            graphQlClient.close();
            return null;
        }
        return graphQlClient.invoke(apiClass, methodInvocation);
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.endpoint == null && configuration.getUrl() != null) {
            this.endpoint = URI.create(configuration.getUrl());
        }
        if (this.headers == null && configuration.getHeaders() != null) {
            this.headers = configuration.getHeaders();
        }
    }

    private String configKey(Class<?> apiClass) {
        GraphQLClientApi annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        if (annotation == null) {
            return apiClass.getName();
        }
        String keyFromAnnotation = annotation.configKey();
        return keyFromAnnotation.isEmpty() ? apiClass.getName() : keyFromAnnotation;
    }
}

