/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.vertx;

import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.typesafe.impl.QueryBuilder;
import io.smallrye.graphql.client.typesafe.impl.ResultBuilder;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import io.smallrye.graphql.client.typesafe.vertx.HeaderBuilder;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jboss.logging.Logger;

class VertxTypesafeGraphQLClientProxy {
    private static final Logger log = Logger.getLogger(VertxTypesafeGraphQLClientProxy.class);
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private final Map<String, String> queryCache = new HashMap<String, String>();
    private final GraphQLClientConfiguration configuration;
    private final URI endpoint;
    private final WebClient webClient;

    VertxTypesafeGraphQLClientProxy(GraphQLClientConfiguration config, URI endpoint, WebClient webClient) {
        this.configuration = config;
        this.endpoint = endpoint;
        this.webClient = webClient;
    }

    Object invoke(Class<?> api, MethodInvocation method) {
        if (method.isDeclaredInObject()) {
            return method.invoke((Object)this);
        }
        MultiMap headers = new HeaderBuilder(api, method, this.configuration != null ? this.configuration.getHeaders() : Collections.emptyMap()).build();
        headers.set("Accept", APPLICATION_JSON_UTF8);
        String request = this.request(method);
        String response = this.post(request, headers);
        log.debugf("response graphql: %s", (Object)response);
        return new ResultBuilder(method, response).read();
    }

    private String request(MethodInvocation method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        String query = this.queryCache.computeIfAbsent(method.getKey(), key -> new QueryBuilder(method).build());
        request.add("query", query);
        request.add("variables", this.variables(method));
        request.add("operationName", method.getName());
        log.debugf("request graphql: %s", (Object)query);
        String requestString = request.build().toString();
        log.debugf("full graphql request: %s", (Object)requestString);
        return requestString;
    }

    private JsonObjectBuilder variables(MethodInvocation method) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        method.valueParameters().forEach(parameter -> builder.add(parameter.getRawName(), this.value(parameter.getValue())));
        return builder;
    }

    private JsonValue value(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        TypeInfo type = TypeInfo.of(value.getClass());
        if (type.isScalar()) {
            return this.scalarValue(value);
        }
        if (type.isCollection()) {
            return this.arrayValue(value);
        }
        return this.objectValue(value, type.fields());
    }

    private JsonValue scalarValue(Object value) {
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Date) {
            return Json.createValue((String)((Date)value).toInstant().toString());
        }
        if (value instanceof Enum) {
            return Json.createValue((String)((Enum)value).name());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value));
        }
        return Json.createValue((String)value.toString());
    }

    private JsonArray arrayValue(Object value) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.values(value).forEach(item -> array.add(this.value(item)));
        return array.build();
    }

    private Collection<?> values(Object value) {
        return value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
    }

    private JsonObject objectValue(Object object, Stream<FieldInfo> fields) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        fields.forEach(field -> {
            if (field.isIncludeNull() || field.get(object) != null) {
                builder.add(field.getName(), this.value(field.get(object)));
            }
        });
        return builder.build();
    }

    private String post(String request, MultiMap headers) {
        Future future = this.webClient.postAbs(this.endpoint.toString()).putHeader("Content-Type", APPLICATION_JSON_UTF8).putHeaders(headers).sendBuffer(Buffer.buffer((String)request));
        try {
            HttpResponse result = (HttpResponse)future.toCompletionStage().toCompletableFuture().get();
            if (result.statusCode() != 200) {
                throw new RuntimeException("expected successful status code but got " + result.statusCode() + " " + result.statusMessage() + ":\n" + result.bodyAsString());
            }
            return result.bodyAsString();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Request failed", e);
        }
    }

    void close() {
        this.webClient.close();
    }
}

