/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.vertx;

import io.smallrye.graphql.client.Request;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.core.Document;
import io.smallrye.graphql.client.dynamic.ErrorImpl;
import io.smallrye.graphql.client.dynamic.RequestImpl;
import io.smallrye.graphql.client.dynamic.ResponseImpl;
import io.smallrye.graphql.client.dynamic.SmallRyeGraphQLDynamicClientLogging;
import io.smallrye.graphql.client.dynamic.SmallRyeGraphQLDynamicClientMessages;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class VertxDynamicGraphQLClient
implements DynamicGraphQLClient {
    private final WebClient webClient;
    private final String url;
    private final MultiMap headers;

    VertxDynamicGraphQLClient(WebClientOptions options, Vertx vertx, String url, MultiMap headers) {
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)options);
        this.headers = headers;
        this.url = url;
    }

    public Response executeSync(Document document) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document));
    }

    public Response executeSync(Request request) throws ExecutionException, InterruptedException {
        HttpResponse result = (HttpResponse)this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(Buffer.buffer((String)request.toJson())).toCompletionStage().toCompletableFuture().get();
        return this.readFrom((Buffer)result.body());
    }

    public Uni<Response> executeAsync(Document document) {
        return this.executeAsync(this.buildRequest(document));
    }

    public Uni<Response> executeAsync(Request request) {
        return Uni.createFrom().completionStage(this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(Buffer.buffer((String)request.toJson())).toCompletionStage()).map(response -> this.readFrom((Buffer)response.body()));
    }

    public Request buildRequest(Document document) {
        return new RequestImpl(document.build());
    }

    public void close() {
        this.webClient.close();
    }

    private ResponseImpl readFrom(Buffer input) {
        JsonObject jsonResponse;
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(input.toString()));
        try {
            jsonResponse = jsonReader.readObject();
        }
        catch (Exception e) {
            throw SmallRyeGraphQLDynamicClientMessages.msg.cannotParseResponse(input.toString());
        }
        JsonObject data = null;
        if (jsonResponse.containsKey((Object)"data")) {
            if (!jsonResponse.isNull("data")) {
                data = jsonResponse.getJsonObject("data");
            } else {
                SmallRyeGraphQLDynamicClientLogging.log.noDataInResponse();
            }
        }
        List errors = null;
        if (jsonResponse.containsKey((Object)"errors")) {
            JsonArray rawErrors = jsonResponse.getJsonArray("errors");
            Jsonb jsonb = JsonbBuilder.create();
            errors = (List)jsonb.fromJson(rawErrors.toString(), new ArrayList<ErrorImpl>(){}.getClass().getGenericSuperclass());
            try {
                jsonb.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ResponseImpl(data, errors);
    }
}

