/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.jaxrs;

import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.jaxrs.JaxRsTypesafeGraphQLClientProxy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;

public class JaxRsTypesafeGraphQLClientBuilder
implements TypesafeGraphQLClientBuilder {
    private String configKey = null;
    private Client client;
    private URI endpoint;

    public TypesafeGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public TypesafeGraphQLClientBuilder client(Client client) {
        this.client = client;
        return this;
    }

    private Client client() {
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        return this.client;
    }

    public TypesafeGraphQLClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TypesafeGraphQLClientBuilder register(Class<?> componentClass) {
        this.client().register(componentClass);
        return this;
    }

    public TypesafeGraphQLClientBuilder register(Object component) {
        this.client().register(component);
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        GraphQLClientConfiguration persistentConfig;
        if (this.configKey == null) {
            this.configKey = this.configKey(apiClass);
        }
        try {
            persistentConfig = (GraphQLClientConfiguration)((GraphQLClientsConfiguration)CDI.current().select(GraphQLClientsConfiguration.class, new Annotation[0]).get()).getClients().get(this.configKey);
        }
        catch (IllegalStateException ex) {
            persistentConfig = null;
        }
        if (persistentConfig != null) {
            this.applyConfig(persistentConfig);
        }
        WebTarget webTarget = this.client().target(this.endpoint);
        JaxRsTypesafeGraphQLClientProxy graphQlClient = new JaxRsTypesafeGraphQLClientProxy(webTarget, persistentConfig);
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> this.invoke(apiClass, graphQlClient, method, args)));
    }

    private Object invoke(Class<?> apiClass, JaxRsTypesafeGraphQLClientProxy graphQlClient, Method method, Object ... args) {
        MethodInvocation methodInvocation = MethodInvocation.of((Method)method, (Object[])args);
        if (methodInvocation.isDeclaredInCloseable()) {
            this.client().close();
            return null;
        }
        return graphQlClient.invoke(apiClass, methodInvocation);
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.endpoint == null && configuration.getUrl() != null) {
            this.endpoint = URI.create(configuration.getUrl());
        }
    }

    private String configKey(Class<?> apiClass) {
        GraphQLClientApi annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        if (annotation == null) {
            return apiClass.getName();
        }
        String keyFromAnnotation = annotation.configKey();
        return keyFromAnnotation.isEmpty() ? apiClass.getName() : keyFromAnnotation;
    }
}

