/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.jaxrs;

import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.jaxrs.JaxRsTypesafeGraphQLClientProxy;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.eclipse.microprofile.config.ConfigProvider;

public class JaxRsTypesafeGraphQLClientBuilder
implements TypesafeGraphQLClientBuilder {
    private String configKey = null;
    private Client client;
    private URI endpoint;

    public TypesafeGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public TypesafeGraphQLClientBuilder client(Client client) {
        this.client = client;
        return this;
    }

    private Client client() {
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        return this.client;
    }

    public TypesafeGraphQLClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TypesafeGraphQLClientBuilder register(Class<?> componentClass) {
        this.client().register(componentClass);
        return this;
    }

    public TypesafeGraphQLClientBuilder register(Object component) {
        this.client().register(component);
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        this.readConfig(apiClass.getAnnotation(GraphQLClientApi.class));
        WebTarget webTarget = this.client().target(this.resolveEndpoint(apiClass));
        JaxRsTypesafeGraphQLClientProxy graphQlClient = new JaxRsTypesafeGraphQLClientProxy(webTarget);
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> this.invoke(apiClass, graphQlClient, method, args)));
    }

    private Object invoke(Class<?> apiClass, JaxRsTypesafeGraphQLClientProxy graphQlClient, Method method, Object ... args) {
        MethodInvocation methodInvocation = MethodInvocation.of((Method)method, (Object[])args);
        if (methodInvocation.isDeclaredInCloseable()) {
            this.client().close();
            return null;
        }
        return graphQlClient.invoke(apiClass, methodInvocation);
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void readConfig(GraphQLClientApi annotation) {
        if (annotation == null) {
            return;
        }
        if (this.endpoint == null && !annotation.endpoint().isEmpty()) {
            this.endpoint = URI.create(annotation.endpoint());
        }
        if (this.configKey == null && !annotation.configKey().isEmpty()) {
            this.configKey = annotation.configKey();
        }
    }

    private URI resolveEndpoint(Class<?> apiClass) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        return (URI)ConfigProvider.getConfig().getValue(this.configKey(apiClass) + "/mp-graphql/url", URI.class);
    }

    private String configKey(Class<?> apiClass) {
        return this.configKey == null ? apiClass.getName() : this.configKey;
    }
}

