/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.generator;

import graphql.language.Argument;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.smallrye.graphql.client.generator.GraphQLGeneratorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Generator {
    private final String pkg;
    private final String apiTypeName;
    private final String schemaString;
    private final List<String> queryStrings;
    private TypeDefinitionRegistry schema;
    private List<Document> queries;

    public Generator(String pkg, String apiTypeName, String schema, List<String> queries) {
        this.pkg = pkg;
        this.apiTypeName = apiTypeName;
        this.schemaString = schema;
        this.queryStrings = queries;
    }

    public Map<String, String> generateSourceFiles() {
        this.schema = this.parseSchema();
        this.queries = this.parseQueries();
        LinkedHashMap<String, String> sourceFiles = new LinkedHashMap<String, String>();
        new Api().addTo(sourceFiles);
        return sourceFiles;
    }

    private TypeDefinitionRegistry parseSchema() {
        try {
            return new SchemaParser().parse(this.schemaString);
        }
        catch (Exception e) {
            throw new GraphQLGeneratorException("can't parse schema: " + this.schemaString, e);
        }
    }

    private List<Document> parseQueries() {
        return this.queryStrings.stream().map(this::query).collect(Collectors.toList());
    }

    private Document query(String query) {
        try {
            return Parser.parse((String)query);
        }
        catch (Exception e) {
            throw new GraphQLGeneratorException("can't parse query: " + query, e);
        }
    }

    private static Collector<CharSequence, ?, String> listString() {
        return Collectors.joining(", ", "[", "]");
    }

    private class TypeGenerator
    extends SourceFileGenerator {
        private final String typeName;
        private final List<String> fieldNames;

        public TypeGenerator(String typeName, List<String> fieldNames) {
            super("class");
            this.typeName = typeName;
            this.fieldNames = fieldNames;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        protected String generateBody() {
            ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)Generator.this.schema.getType(this.typeName).orElseThrow(() -> new GraphQLGeneratorException("type '" + this.typeName + "' not found in schema"));
            return typeDefinition.getFieldDefinitions().stream().filter(field -> this.fieldNames.contains(field.getName())).map(this::toJava).collect(Collectors.joining(";\n    ", "    ", ";\n"));
        }

        private String toJava(FieldDefinition field) {
            return new SourceFileGenerator.JavaType(field.getType(), this.fieldNames) + " " + field.getName();
        }
    }

    private class Api
    extends SourceFileGenerator {
        private final StringBuilder body;

        public Api() {
            super("interface");
            this.body = new StringBuilder();
        }

        @Override
        public String getTypeName() {
            return Generator.this.apiTypeName;
        }

        @Override
        protected String generateBody() {
            Generator.this.queries.forEach(this::generateQueryMethod);
            return this.body.toString();
        }

        private void generateQueryMethod(Document query) {
            List definitions = query.getDefinitionsOfType(OperationDefinition.class);
            if (definitions.size() != 1) {
                throw new GraphQLGeneratorException("expected exactly one definition but found " + definitions.stream().map(this::operationInfo).collect(Generator.listString()));
            }
            OperationDefinition operation = (OperationDefinition)definitions.get(0);
            List fields = operation.getSelectionSet().getSelectionsOfType(Field.class);
            if (fields.size() != 1) {
                throw new GraphQLGeneratorException("expected exactly one field but got " + fields.stream().map(Field::getName).collect(Generator.listString()));
            }
            Field field = (Field)fields.get(0);
            this.body.append(new MethodGenerator(operation, field));
        }

        private String operationInfo(OperationDefinition definition) {
            return definition.getOperation().toString().toLowerCase() + " " + definition.getName();
        }

        private class MethodGenerator {
            private final OperationDefinition operation;
            private final Field method;
            private final StringBuilder annotations = new StringBuilder();

            public MethodGenerator(OperationDefinition operation, Field method) {
                this.operation = operation;
                this.method = method;
            }

            public String toString() {
                SourceFileGenerator.JavaType returnType = this.returnType();
                String methodName = this.methodName();
                String argumentList = this.argumentList();
                return "    " + this.annotations + returnType + " " + methodName + argumentList + ";\n";
            }

            private SourceFileGenerator.JavaType returnType() {
                ObjectTypeDefinition query = (ObjectTypeDefinition)Generator.this.schema.getType("Query").orElseThrow(() -> new GraphQLGeneratorException("'Query' type not found in schema"));
                FieldDefinition fieldDefinition = query.getFieldDefinitions().stream().filter(f -> f.getName().equals(this.method.getName())).findAny().orElseThrow(() -> new GraphQLGeneratorException("field (method) '" + this.method.getName() + "' not found in " + query.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Generator.listString())));
                List<String> selections = this.operation.getSelectionSet().getSelectionsOfType(Field.class).stream().flatMap(this::selectedFields).map(Field::getName).collect(Collectors.toList());
                return new SourceFileGenerator.JavaType(fieldDefinition.getType(), selections);
            }

            private Stream<? extends Field> selectedFields(Field field) {
                SelectionSet selectionSet = field.getSelectionSet();
                return selectionSet == null ? Stream.of(new Field[0]) : selectionSet.getSelectionsOfType(Field.class).stream();
            }

            public String methodName() {
                if (this.method.getAlias() != null) {
                    this.nameQuery();
                    return this.method.getAlias();
                }
                if (this.operation.getName() == null) {
                    return this.method.getName();
                }
                if (!this.operation.getName().equals(this.method.getName())) {
                    this.nameQuery();
                }
                return this.operation.getName();
            }

            private void nameQuery() {
                Api.this.imports.add("org.eclipse.microprofile.graphql.Query");
                this.annotations.append("@Query(\"").append(this.method.getName()).append("\") ");
            }

            public String argumentList() {
                return new ArgumentList(this.method, this.operation.getVariableDefinitions()).toString();
            }

            private class ArgumentList {
                private final Field field;
                private final List<VariableDefinition> variableDefinitions;

                public ArgumentList(Field field, List<VariableDefinition> variableDefinitions) {
                    this.field = field;
                    this.variableDefinitions = variableDefinitions;
                }

                public String toString() {
                    return this.field.getArguments().stream().map(argument -> new SourceFileGenerator.JavaType(this.type((Argument)argument), Collections.emptyList()) + " " + argument.getName()).collect(Collectors.joining(", ", "(", ")"));
                }

                private Type<?> type(Argument argument) {
                    Value value = argument.getValue();
                    if (value instanceof VariableReference) {
                        return this.resolve(((VariableReference)value).getName());
                    }
                    throw new GraphQLGeneratorException("unsupported type " + value + " for argument '" + argument.getName() + "'");
                }

                private Type<?> resolve(String name) {
                    return this.variableDefinitions.stream().filter(var -> var.getName().equals(name)).findAny().map(VariableDefinition::getType).orElseThrow(() -> new GraphQLGeneratorException("no definition found for parameter '" + name + "' in " + this.variableDefinitions.stream().map(VariableDefinition::getName).collect(Generator.listString())));
                }
            }
        }
    }

    private abstract class SourceFileGenerator {
        protected final String typeType;
        protected final Set<String> imports = new TreeSet<String>();
        final List<SourceFileGenerator> other = new ArrayList<SourceFileGenerator>();

        protected abstract String generateBody();

        public SourceFileGenerator(String typeType) {
            this.typeType = typeType;
        }

        public abstract String getTypeName();

        public void addTo(Map<String, String> sourceFiles) {
            String body = this.generateBody();
            String source = "package " + Generator.this.pkg + ";\n\n" + this.imports() + "public " + this.typeType + " " + this.getTypeName() + " {\n" + body + "}\n";
            String previousSource = sourceFiles.put(Generator.this.pkg + "." + this.getTypeName(), source);
            if (previousSource != null && !previousSource.equals(source)) {
                throw new GraphQLGeneratorException("already generated " + this.getTypeName());
            }
            this.other.forEach(it -> it.addTo(sourceFiles));
        }

        private String imports() {
            return this.imports.isEmpty() ? "" : this.imports.stream().collect(Collectors.joining(";\nimport ", "import ", ";\n\n"));
        }

        protected class JavaType {
            private final Type<?> type;
            private final List<String> fieldNames;

            public JavaType(Type<?> type, List<String> fieldNames) {
                this.type = type;
                this.fieldNames = fieldNames;
            }

            public String toString() {
                if (this.type instanceof ListType) {
                    return this.toListJava((ListType)this.type);
                }
                if (this.type instanceof NonNullType) {
                    return this.toNonNullJava((NonNullType)this.type);
                }
                if (this.type instanceof TypeName) {
                    return this.toJava((TypeName)this.type);
                }
                throw new UnsupportedOperationException("unexpected type of type");
            }

            private String toListJava(ListType type) {
                SourceFileGenerator.this.imports.add("java.util.List");
                return "List<" + new JavaType(type.getType(), this.fieldNames) + ">";
            }

            private String toNonNullJava(NonNullType type) {
                SourceFileGenerator.this.imports.add("org.eclipse.microprofile.graphql.NonNull");
                return "@NonNull " + new JavaType(type.getType(), this.fieldNames);
            }

            private String toJava(TypeName typeName) {
                String string;
                switch (string = typeName.getName()) {
                    case "Int": {
                        return "Integer";
                    }
                    case "Boolean": 
                    case "Float": 
                    case "String": {
                        return string;
                    }
                    case "ID": {
                        return "String";
                    }
                }
                SourceFileGenerator.this.other.add(new TypeGenerator(string, this.fieldNames));
                return string;
            }
        }
    }
}

