/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import jakarta.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypesafeResponse<T>
extends ErrorOr<T> {
    private Map<String, List<String>> transportMeta;
    private JsonObject extensions;

    public static <T> TypesafeResponse<T> of(T value) {
        return new TypesafeResponse<T>(Objects.requireNonNull(value, "value must not be null"), null);
    }

    public static <T> TypesafeResponse<T> ofErrors(List<GraphQLError> errors) {
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("errors must not be empty");
        }
        return new TypesafeResponse<Object>(null, Collections.unmodifiableList(new ArrayList<GraphQLError>(errors)));
    }

    private TypesafeResponse(T value, List<GraphQLError> errors) {
        super(value, errors);
    }

    private TypesafeResponse(TypesafeResponse<T> typesafeResponse, Map<String, List<String>> transportMeta, JsonObject extensions) {
        super(typesafeResponse.isPresent() ? (Object)typesafeResponse.get() : null, typesafeResponse.hasErrors() ? typesafeResponse.getErrors() : null);
        this.transportMeta = transportMeta;
        this.extensions = extensions;
    }

    public static <T> TypesafeResponse<T> withTransportMetaAndExtensions(TypesafeResponse<T> typesafeResponse, Map<String, List<String>> transportMeta, JsonObject responseExtensions) {
        return new TypesafeResponse<T>(typesafeResponse, transportMeta, responseExtensions);
    }

    public Map<String, List<String>> getTransportMeta() {
        return this.transportMeta;
    }

    public JsonObject getExtensions() {
        return this.extensions;
    }

    @Override
    public String toString() {
        return "TypesafeResponse(" + (this.isPresent() ? "value=" + this.get() : "errors=" + this.getErrors()) + ", transportMeta=" + this.transportMeta + ", responseExtensions=" + this.extensions + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypesafeResponse that = (TypesafeResponse)o;
        return Objects.equals(this.transportMeta, that.transportMeta) && Objects.equals(this.extensions, that.extensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transportMeta, this.extensions);
    }
}

