/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core.utils.validation;

import java.util.regex.Pattern;

public class NameValidation {
    private static final String _NAME_REGEX = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String _FIELD_NAME_REGEX = "^[a-zA-Z_][a-zA-Z0-9_]*(:[a-zA-Z_][a-zA-Z0-9_]*)?$";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*(:[a-zA-Z_][a-zA-Z0-9_]*)?$");

    public static String validateNameAllowEmpty(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return name;
    }

    public static String validateFragmentName(String name) {
        if (name == null || !NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid fragment name: " + name);
        }
        if (name.equals("on")) {
            throw new IllegalArgumentException("Fragment name cannot be 'on'");
        }
        return name;
    }

    public static String validateName(String name) {
        if (name == null || !NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return name;
    }

    public static String validateFieldName(String fieldName) {
        if (fieldName == null || !NameValidation.nameMatchesPattern(fieldName, FIELD_NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid field name: " + fieldName);
        }
        return fieldName;
    }

    private static boolean nameMatchesPattern(String name, Pattern pattern) {
        return pattern.matcher(name).matches();
    }
}

