/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client;

import io.smallrye.graphql.client.GraphQLError;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GraphQLClientException
extends RuntimeException {
    private final List<GraphQLError> errors;

    public GraphQLClientException(String message, GraphQLError error) {
        super(message);
        this.errors = Collections.singletonList(Objects.requireNonNull(error));
    }

    public GraphQLClientException(String message, List<GraphQLError> errors) {
        super(message);
        this.errors = Objects.requireNonNull(errors);
    }

    @Override
    public String toString() {
        return "GraphQlClientException: " + this.getMessage() + (this.errors.isEmpty() ? "" : "\nerrors:\n- " + this.errors.stream().map(Object::toString).collect(Collectors.joining("\n- "))) + ")";
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }
}

