/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.typesafe.api.GraphQLClientError;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GraphQLClientException
extends RuntimeException {
    private final List<GraphQLClientError> errors;

    public GraphQLClientException(String message) {
        super(message);
        this.errors = Collections.emptyList();
    }

    public GraphQLClientException(String message, List<GraphQLClientError> errors) {
        super(message);
        this.errors = Objects.requireNonNull(errors);
    }

    public GraphQLClientException(String message, Throwable cause) {
        super(message, cause);
        this.errors = Collections.emptyList();
    }

    @Override
    public String toString() {
        return "GraphQlClientException: " + this.getMessage() + (this.errors.isEmpty() ? "" : "\nerrors:\n- " + this.errors.stream().map(Object::toString).collect(Collectors.joining("\n- "))) + ")";
    }

    public List<GraphQLClientError> getErrors() {
        return this.errors;
    }
}

