/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import java.net.URI;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface TypesafeGraphQLClientBuilder {
    public static TypesafeGraphQLClientBuilder newBuilder() {
        ServiceLoader<TypesafeGraphQLClientBuilder> loader = ServiceLoader.load(TypesafeGraphQLClientBuilder.class);
        Iterator<TypesafeGraphQLClientBuilder> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ServiceConfigurationError("no " + TypesafeGraphQLClientBuilder.class.getName() + " in classpath");
        }
        TypesafeGraphQLClientBuilder graphQlClientBuilder = iterator.next();
        if (iterator.hasNext()) {
            throw new ServiceConfigurationError("more than one " + TypesafeGraphQLClientBuilder.class.getName() + " in classpath");
        }
        return graphQlClientBuilder;
    }

    public TypesafeGraphQLClientBuilder configKey(String var1);

    default public TypesafeGraphQLClientBuilder endpoint(String endpoint) {
        return this.endpoint(URI.create(endpoint));
    }

    public TypesafeGraphQLClientBuilder endpoint(URI var1);

    public <T> T build(Class<T> var1);
}

