/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientApi;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientHeader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class GraphQlClientAuthorizationHeader
extends GraphQlClientHeader {
    private static final Config CONFIG = ConfigProvider.getConfig();

    public GraphQlClientAuthorizationHeader(Class<?> api) {
        this(GraphQlClientAuthorizationHeader.configKey(api));
    }

    private static String configKey(Class<?> api) {
        GraphQlClientApi annotation = api.getAnnotation(GraphQlClientApi.class);
        if (annotation == null || annotation.configKey().isEmpty()) {
            return api.getName();
        }
        return annotation.configKey();
    }

    public GraphQlClientAuthorizationHeader() {
        this("");
    }

    public GraphQlClientAuthorizationHeader(String configKey) {
        super("Authorization", GraphQlClientAuthorizationHeader.auth(configKey));
    }

    private static Supplier<Object> auth(String configKey) {
        String prefix = configKey.isEmpty() ? "" : configKey + "/mp-graphql/";
        return () -> {
            String username = (String)CONFIG.getValue(prefix + "username", String.class);
            String password = (String)CONFIG.getValue(prefix + "password", String.class);
            String token = username + ":" + password;
            return "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
        };
    }
}

