/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.api.federation.link;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.graphql.api.Directive;
import io.smallrye.graphql.api.DirectiveLocation;
import io.smallrye.graphql.api.federation.link.Import;
import io.smallrye.graphql.api.federation.link.Purpose;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

@Directive(on={DirectiveLocation.SCHEMA})
@Description(value="This directive links definitions from an external specification to this schema.")
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=Links.class)
@Experimental(value="SmallRye GraphQL Federation is still subject to change.")
public @interface Link {
    public static final String FEDERATION_SPEC_URL = "https://specs.apollo.dev/federation";
    public static final String FEDERATION_SPEC_LATEST_VER = "2.7";
    public static final String FEDERATION_SPEC_LATEST_URL = "https://specs.apollo.dev/federation/v2.7";

    @NonNull
    @Description(value="The foreign schema\u2019s URL.")
    public String url();

    @Description(value="Change the namespace prefix assigned to the foreign schema.")
    public String as() default "";

    @Description(value="A list of elements to import from the foreign schema into the document.")
    @Name(value="import")
    public Import[] _import() default {};

    @Description(value="An optional purpose for this link. This hints to consumers as to whether they can safely ignore metadata described by a foreign schema.")
    @Name(value="for")
    public Purpose _for() default Purpose.UNDEFINED;

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Links {
        public Link[] value();
    }
}

