/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.api.federation;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.graphql.api.Directive;
import io.smallrye.graphql.api.DirectiveLocation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.NonNull;

@Directive(on={DirectiveLocation.FIELD_DEFINITION})
@Description(value="Specifies a set of entity fields that a subgraph can resolve, but only at a particular schema path (at other paths, the subgraph can't resolve those fields).\nIf a subgraph can always resolve a particular entity field, do not apply this directive.\nUsing this directive is always an optional optimization. It can reduce the total number of subgraphs that your graph router needs to communicate with to resolve certain operations, which can improve performance.")
@Retention(value=RetentionPolicy.RUNTIME)
@Experimental(value="SmallRye GraphQL Federation is still subject to change.")
public @interface Provides {
    @NonNull
    @Description(value="A GraphQL selection set (provided as a string) of object fields and subfields that the subgraph can resolve only at this query path.\nExamples:\n\"name\"\n\"name address\"\n\"... on Person { name address }\" (valid for fields that return a union or interface)")
    public String fields();
}

