/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.context.ThreadContext;

final class ContextPropagatingScheduledExecutorService
implements ScheduledExecutorService {
    private final ThreadContext threadContext;
    private final ScheduledExecutorService delegate;

    ContextPropagatingScheduledExecutorService(ThreadContext threadContext, ScheduledExecutorService delegate) {
        this.threadContext = threadContext;
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.threadContext.contextualRunnable(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.threadContext.contextualCallable(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(this.threadContext.contextualRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(this.threadContext.contextualRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.threadContext.contextualCallable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.threadContext.contextualRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.threadContext.contextualRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable> contextualTasks = new ArrayList<Callable>(tasks.size());
        for (Callable<T> task : tasks) {
            contextualTasks.add(this.threadContext.contextualCallable(task));
        }
        return this.delegate.invokeAll(contextualTasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable> contextualTasks = new ArrayList<Callable>(tasks.size());
        for (Callable<T> task : tasks) {
            contextualTasks.add(this.threadContext.contextualCallable(task));
        }
        return this.delegate.invokeAll(contextualTasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable> contextualTasks = new ArrayList<Callable>(tasks.size());
        for (Callable<T> task : tasks) {
            contextualTasks.add(this.threadContext.contextualCallable(task));
        }
        return this.delegate.invokeAny(contextualTasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable> contextualTasks = new ArrayList<Callable>(tasks.size());
        for (Callable<T> task : tasks) {
            contextualTasks.add(this.threadContext.contextualCallable(task));
        }
        return this.delegate.invokeAny(contextualTasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.threadContext.contextualRunnable(command));
    }
}

