/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava1;

import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.functions.Func1;

public class ContextPropagatorOnSingleCreateAction
implements Func1<Single.OnSubscribe, Single.OnSubscribe> {
    private ThreadContext threadContext;

    public ContextPropagatorOnSingleCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public Single.OnSubscribe call(Single.OnSubscribe t) {
        return new ContextCapturerSingle(t, this.threadContext.currentContextExecutor());
    }

    static final class ContextCapturerSingle<T>
    implements Single.OnSubscribe<T> {
        final Single.OnSubscribe<T> source;
        private Executor contextExecutor;

        public ContextCapturerSingle(Single.OnSubscribe<T> source, Executor contextExecutor) {
            this.source = source;
            this.contextExecutor = contextExecutor;
        }

        public void call(SingleSubscriber<? super T> t) {
            this.contextExecutor.execute(() -> this.source.call(new OnAssemblySingleSubscriber(t, this.contextExecutor)));
        }

        static final class OnAssemblySingleSubscriber<T>
        extends SingleSubscriber<T> {
            final SingleSubscriber<? super T> actual;
            private final Executor contextExecutor;

            public OnAssemblySingleSubscriber(SingleSubscriber<? super T> actual, Executor contextExecutor) {
                this.actual = actual;
                this.contextExecutor = contextExecutor;
                actual.add((Subscription)this);
            }

            public void onError(Throwable e) {
                this.contextExecutor.execute(() -> this.actual.onError(e));
            }

            public void onSuccess(T t) {
                this.contextExecutor.execute(() -> this.actual.onSuccess(t));
            }
        }
    }
}

