/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.cdi.context.propagation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;
import org.jboss.weld.context.WeldAlterableContext;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundLiteral;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.MutableBoundRequest;
import org.jboss.weld.manager.api.WeldManager;

public class CdiContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        if (!this.isCdiAvailable()) {
            return null;
        }
        WeldManager weldManager = (WeldManager)CDI.current().select(WeldManager.class, new Annotation[0]).get();
        HashMap<Class, Collection> scopeToContextualInstances = new HashMap<Class, Collection>();
        for (WeldAlterableContext context : weldManager.getActiveWeldAlterableContexts()) {
            scopeToContextualInstances.put(context.getScope(), context.getAllContextualInstances());
        }
        return () -> {
            ThreadContextController controller;
            boolean isContextActiveOnThisThread = this.areContextsAlreadyActive(weldManager, scopeToContextualInstances.keySet());
            if (!isContextActiveOnThisThread) {
                BoundRequestContext requestContext = (BoundRequestContext)weldManager.instance().select(BoundRequestContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                BoundSessionContext sessionContext = (BoundSessionContext)weldManager.instance().select(BoundSessionContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                BoundConversationContext conversationContext = (BoundConversationContext)weldManager.instance().select(BoundConversationContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                HashMap requestMap = null;
                HashMap sessionMap = null;
                if (scopeToContextualInstances.containsKey(requestContext.getScope())) {
                    requestMap = new HashMap();
                    requestContext.associate(requestMap);
                    requestContext.activate();
                }
                if (scopeToContextualInstances.containsKey(sessionContext.getScope())) {
                    sessionMap = new HashMap();
                    sessionContext.associate(sessionMap);
                    sessionContext.activate();
                }
                if (scopeToContextualInstances.containsKey(conversationContext.getScope()) && requestMap != null && sessionMap != null) {
                    conversationContext.associate((Object)new MutableBoundRequest(requestMap, sessionMap));
                    conversationContext.activate();
                }
                if (scopeToContextualInstances.get(requestContext.getScope()) != null) {
                    requestContext.clearAndSet((Collection)scopeToContextualInstances.get(requestContext.getScope()));
                }
                if (scopeToContextualInstances.get(sessionContext.getScope()) != null) {
                    sessionContext.clearAndSet((Collection)scopeToContextualInstances.get(sessionContext.getScope()));
                }
                if (scopeToContextualInstances.get(conversationContext.getScope()) != null) {
                    conversationContext.clearAndSet((Collection)scopeToContextualInstances.get(conversationContext.getScope()));
                }
                controller = () -> {
                    if (scopeToContextualInstances.containsKey(requestContext.getScope())) {
                        requestContext.deactivate();
                    }
                    if (scopeToContextualInstances.containsKey(sessionContext.getScope())) {
                        sessionContext.deactivate();
                    }
                    if (scopeToContextualInstances.containsKey(conversationContext.getScope())) {
                        conversationContext.deactivate();
                    }
                };
            } else {
                HashMap<Class, Collection> scopeToInstancesToRestoreInTheEnd = new HashMap<Class, Collection>();
                HashMap<Class, WeldAlterableContext> scopeToContextMap = new HashMap<Class, WeldAlterableContext>();
                for (WeldAlterableContext context : weldManager.getActiveWeldAlterableContexts()) {
                    scopeToInstancesToRestoreInTheEnd.put(context.getScope(), context.getAllContextualInstances());
                    scopeToContextMap.put(context.getScope(), context);
                }
                WeldAlterableContext requestContext = (WeldAlterableContext)scopeToContextMap.get(RequestScoped.class);
                WeldAlterableContext sessionContext = (WeldAlterableContext)scopeToContextMap.get(SessionScoped.class);
                WeldAlterableContext conversationContext = (WeldAlterableContext)scopeToContextMap.get(ConversationScoped.class);
                if (requestContext != null && scopeToContextualInstances.get(requestContext.getScope()) != null) {
                    requestContext.clearAndSet((Collection)scopeToContextualInstances.get(requestContext.getScope()));
                }
                if (sessionContext != null && scopeToContextualInstances.get(sessionContext.getScope()) != null) {
                    sessionContext.clearAndSet((Collection)scopeToContextualInstances.get(sessionContext.getScope()));
                }
                if (conversationContext != null && scopeToContextualInstances.get(conversationContext.getScope()) != null) {
                    conversationContext.clearAndSet((Collection)scopeToContextualInstances.get(conversationContext.getScope()));
                }
                controller = () -> {
                    if (requestContext != null && scopeToInstancesToRestoreInTheEnd.get(requestContext.getScope()) != null) {
                        requestContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(requestContext.getScope()));
                    }
                    if (sessionContext != null && scopeToInstancesToRestoreInTheEnd.get(sessionContext.getScope()) != null) {
                        sessionContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(sessionContext.getScope()));
                    }
                    if (conversationContext != null && scopeToInstancesToRestoreInTheEnd.get(conversationContext.getScope()) != null) {
                        conversationContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(conversationContext.getScope()));
                    }
                };
            }
            return controller;
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        if (!this.isCdiAvailable()) {
            return null;
        }
        WeldManager weldManager = (WeldManager)CDI.current().select(WeldManager.class, new Annotation[0]).get();
        HashSet<Class> activeScopes = new HashSet<Class>();
        for (WeldAlterableContext context : weldManager.getActiveWeldAlterableContexts()) {
            activeScopes.add(context.getScope());
        }
        return () -> {
            ThreadContextController controller;
            boolean isContextActiveOnThisThread = this.areContextsAlreadyActive(weldManager, activeScopes);
            if (!isContextActiveOnThisThread) {
                BoundRequestContext requestContext = (BoundRequestContext)weldManager.instance().select(BoundRequestContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                BoundSessionContext sessionContext = (BoundSessionContext)weldManager.instance().select(BoundSessionContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                BoundConversationContext conversationContext = (BoundConversationContext)weldManager.instance().select(BoundConversationContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
                HashMap requestMap = null;
                HashMap sessionMap = null;
                if (activeScopes.contains(requestContext.getScope())) {
                    requestMap = new HashMap();
                    requestContext.associate(requestMap);
                    requestContext.activate();
                }
                if (activeScopes.contains(sessionContext.getScope())) {
                    sessionMap = new HashMap();
                    sessionContext.associate(sessionMap);
                    sessionContext.activate();
                }
                if (activeScopes.contains(conversationContext.getScope()) && requestMap != null && sessionMap != null) {
                    conversationContext.associate((Object)new MutableBoundRequest(requestMap, sessionMap));
                    conversationContext.activate();
                }
                controller = () -> {
                    if (activeScopes.contains(requestContext.getScope())) {
                        requestContext.deactivate();
                    }
                    if (activeScopes.contains(sessionContext.getScope())) {
                        sessionContext.deactivate();
                    }
                    if (activeScopes.contains(conversationContext.getScope())) {
                        conversationContext.deactivate();
                    }
                };
            } else {
                HashMap<Class, Collection> scopeToInstancesToRestoreInTheEnd = new HashMap<Class, Collection>();
                HashMap<Class, WeldAlterableContext> scopeToContextMap = new HashMap<Class, WeldAlterableContext>();
                for (WeldAlterableContext context : weldManager.getActiveWeldAlterableContexts()) {
                    scopeToInstancesToRestoreInTheEnd.put(context.getScope(), context.getAllContextualInstances());
                    scopeToContextMap.put(context.getScope(), context);
                }
                WeldAlterableContext requestContext = (WeldAlterableContext)scopeToContextMap.get(RequestScoped.class);
                WeldAlterableContext sessionContext = (WeldAlterableContext)scopeToContextMap.get(SessionScoped.class);
                WeldAlterableContext conversationContext = (WeldAlterableContext)scopeToContextMap.get(ConversationScoped.class);
                if (requestContext != null & activeScopes.contains(requestContext.getScope())) {
                    requestContext.clearAndSet(Collections.emptySet());
                }
                if (sessionContext != null && activeScopes.contains(sessionContext.getScope())) {
                    sessionContext.clearAndSet(Collections.emptySet());
                }
                if (conversationContext != null && activeScopes.contains(conversationContext.getScope())) {
                    conversationContext.clearAndSet(Collections.emptySet());
                }
                controller = () -> {
                    if (requestContext != null && scopeToInstancesToRestoreInTheEnd.get(requestContext.getScope()) != null) {
                        requestContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(requestContext.getScope()));
                    }
                    if (sessionContext != null && scopeToInstancesToRestoreInTheEnd.get(sessionContext.getScope()) != null) {
                        sessionContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(sessionContext.getScope()));
                    }
                    if (conversationContext != null && scopeToInstancesToRestoreInTheEnd.get(conversationContext.getScope()) != null) {
                        conversationContext.clearAndSet((Collection)scopeToInstancesToRestoreInTheEnd.get(conversationContext.getScope()));
                    }
                };
            }
            return controller;
        };
    }

    public String getThreadContextType() {
        return "CDI";
    }

    private boolean isCdiAvailable() {
        try {
            return CDI.current() != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private boolean areContextsAlreadyActive(WeldManager manager, Set<Class<? extends Annotation>> scopes) {
        return scopes.stream().filter(scope -> manager.isContextActive(scope)).findAny().isPresent();
    }
}

