/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.application.context.propagation;

import io.smallrye.context.FastThreadContextProvider;
import java.security.AccessController;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ApplicationContextProvider
implements FastThreadContextProvider {
    static final ClassLoader SYSTEM_CL;
    static final ThreadLocal<ClassLoader> PRETEND_TL;

    private static ClassLoader calculateSystemClassLoader() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl == null) {
            cl = new ClassLoader(null){};
        }
        return cl;
    }

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        final ClassLoader capturedTCCL = Thread.currentThread().getContextClassLoader();
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                final ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
                if (capturedTCCL != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(capturedTCCL);
                }
                return new ThreadContextController(){

                    public void endContext() throws IllegalStateException {
                        if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                            Thread.currentThread().setContextClassLoader(movedTCCL);
                        }
                    }
                };
            }
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        final ClassLoader capturedTCCL = SYSTEM_CL;
        return new ThreadContextSnapshot(){

            public ThreadContextController begin() {
                final ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
                if (capturedTCCL != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(capturedTCCL);
                }
                return new ThreadContextController(){

                    public void endContext() throws IllegalStateException {
                        if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                            Thread.currentThread().setContextClassLoader(movedTCCL);
                        }
                    }
                };
            }
        };
    }

    public String getThreadContextType() {
        return "Application";
    }

    public ThreadLocal<?> threadLocal(Map<String, String> props) {
        return PRETEND_TL;
    }

    public Object clearedValue(Map<String, String> props) {
        return SYSTEM_CL;
    }

    static {
        PRETEND_TL = new ThreadLocal<ClassLoader>(){

            @Override
            public ClassLoader get() {
                return Thread.currentThread().getContextClassLoader();
            }

            @Override
            public void set(ClassLoader value) {
                Thread.currentThread().setContextClassLoader(value);
            }

            @Override
            public void remove() {
                Thread.currentThread().setContextClassLoader(SYSTEM_CL);
            }
        };
        SecurityManager sm = System.getSecurityManager();
        SYSTEM_CL = sm != null ? AccessController.doPrivileged(ApplicationContextProvider::calculateSystemClassLoader) : ApplicationContextProvider.calculateSystemClassLoader();
    }
}

