/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.application.context.propagation;

import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ApplicationContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        ClassLoader capturedTCCL = Thread.currentThread().getContextClassLoader();
        return () -> {
            ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
            if (capturedTCCL != movedTCCL) {
                Thread.currentThread().setContextClassLoader(capturedTCCL);
            }
            return () -> {
                if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(movedTCCL);
                }
            };
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        ClassLoader capturedTCCL = null;
        return () -> {
            ClassLoader movedTCCL = Thread.currentThread().getContextClassLoader();
            if (capturedTCCL != movedTCCL) {
                Thread.currentThread().setContextClassLoader(capturedTCCL);
            }
            return () -> {
                if (Thread.currentThread().getContextClassLoader() != movedTCCL) {
                    Thread.currentThread().setContextClassLoader(movedTCCL);
                }
            };
        };
    }

    public String getThreadContextType() {
        return "Application";
    }
}

