/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.powerannotations.scanner;

import com.github.t1.powerannotations.common.PowerAnnotations;
import com.github.t1.powerannotations.scanner.IndexerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

public class Scanner {
    private final Indexer indexer = new Indexer();
    private final IndexerConfig config = new IndexerConfig();
    private int archivesIndexed;
    private int classesIndexed;

    public Index scanClassPath() {
        long t = System.currentTimeMillis();
        this.urls().distinct().filter(this::include).forEach(this::index);
        Index index = this.indexer.complete();
        PowerAnnotations.log.info("scanned " + this.archivesIndexed + " archives with " + this.classesIndexed + " classes in " + (System.currentTimeMillis() - t) + "ms");
        return index;
    }

    private Stream<URL> urls() {
        return Stream.of(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).map(Scanner::toUrl);
    }

    private static URL toUrl(String url) {
        try {
            return Paths.get(url, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("invalid classpath url " + url, e);
        }
    }

    private boolean include(URL url) {
        String urlString = url.toString();
        return this.config.excludes().noneMatch(urlString::matches);
    }

    private void index(URL url) {
        try {
            long t0 = System.currentTimeMillis();
            int classesIndexedBefore = this.classesIndexed;
            if (url.toString().endsWith(".jar") || url.toString().endsWith(".war")) {
                this.indexArchive(url.openStream());
            } else {
                this.indexFolder(url);
            }
            PowerAnnotations.log.info("indexed " + (this.classesIndexed - classesIndexedBefore) + " classes in " + url + " in " + (System.currentTimeMillis() - t0) + " ms");
        }
        catch (IOException e) {
            throw new RuntimeException("can't index " + url, e);
        }
    }

    private void indexArchive(InputStream inputStream) throws IOException {
        ZipEntry entry;
        ++this.archivesIndexed;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            this.indexFile(entryName, zipInputStream);
        }
    }

    private void indexFile(String fileName, InputStream inputStream) throws IOException {
        if (fileName.endsWith(".class")) {
            ++this.classesIndexed;
            this.indexer.index(inputStream);
        } else if (fileName.endsWith(".war")) {
            this.indexArchive(inputStream);
        }
    }

    private void indexFolder(URL url) throws IOException {
        block8: {
            try {
                Path folderPath = Paths.get(url.toURI());
                if (!Files.isDirectory(folderPath, new LinkOption[0])) break block8;
                try (Stream<Path> walk = Files.walk(folderPath, new FileVisitOption[0]);){
                    walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this::indexFile);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("invalid folder url " + url, e);
            }
        }
    }

    private void indexFile(Path path) {
        try {
            String entryName = path.getFileName().toString();
            this.indexFile(entryName, Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("can't index path " + path, e);
        }
    }
}

