/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.powerannotations.scanner;

import com.github.t1.powerannotations.common.PowerAnnotations;
import com.github.t1.powerannotations.scanner.Scanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public class IndexBuilder {
    public static Index loadOrScan() {
        return IndexBuilder.load().orElseGet(IndexBuilder::scan);
    }

    private static Optional<Index> load() {
        Optional<Index> optional;
        block8: {
            InputStream inputStream = IndexBuilder.getClassLoader().getResourceAsStream("META-INF/jandex.idx");
            try {
                optional = Optional.ofNullable(inputStream).map(IndexBuilder::load);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new RuntimeException("can't read index file", e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    private static Index load(InputStream inputStream) {
        try {
            return new IndexReader(inputStream).read();
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("can't read Jandex input stream", e);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    private static Index scan() {
        Index index = new Scanner().scanClassPath();
        new PowerAnnotations(index).resolveAnnotations();
        return index;
    }
}

