/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.powerannotations.scanner;

import com.github.t1.powerannotations.scanner.Scanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public class IndexBuilder {
    public static Index loadOrScan() {
        return IndexBuilder.load().orElseGet(Scanner::scan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Index> load() {
        try (InputStream inputStream = IndexBuilder.getClassLoader().getResourceAsStream("META-INF/jandex.idx");){
            Optional<Index> optional = Optional.ofNullable(inputStream).map(IndexBuilder::load);
            return optional;
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("can't read index file", e);
        }
    }

    private static Index load(InputStream inputStream) {
        try {
            return new IndexReader(inputStream).read();
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("can't read Jandex input stream", e);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }
}

