/*
 * Decompiled with CFR 0.152.
 */
package io.slifer.csv;

import com.opencsv.CSVReader;
import io.slifer.csv.CsvFile;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CsvLoader {
    public static CsvFile load(String fileName, boolean preserveSpaces) {
        return CsvLoader.importCsvData(fileName, preserveSpaces);
    }

    public static CsvFile load(String fileName) {
        return CsvLoader.importCsvData(fileName, false);
    }

    private static CsvFile importCsvData(String fileName, boolean preserveSpaces) {
        String[] header;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try {
            InputStream inputStream = CsvFile.class.getClassLoader().getResourceAsStream(fileName);
            CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(inputStream));
            List csv = csvReader.readAll();
            header = CsvLoader.cleanRowValues((String[])csv.get(0));
            for (int i = 1; i < csv.size(); ++i) {
                if (((String[])csv.get(i)).length == 1) continue;
                String[] row = preserveSpaces ? (String[])csv.get(i) : CsvLoader.cleanRowValues((String[])csv.get(i));
                rows.add(row);
            }
            csvReader.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while loading file [" + fileName + "].");
        }
        return new CsvFile(header, rows);
    }

    private static String[] cleanRowValues(String[] row) {
        for (int i = 0; i < row.length; ++i) {
            row[i] = row[i].strip();
        }
        return row;
    }
}

