/*
 * Decompiled with CFR 0.152.
 */
package io.slifer.csv;

import java.util.ArrayList;
import java.util.List;

public class CsvFile {
    private String[] header;
    private List<String[]> rows;
    private int currentRow;

    public CsvFile(String[] header, List<String[]> rows) {
        this.header = header;
        this.rows = rows;
        this.currentRow = 0;
    }

    public CsvFile filter(String filterBy) {
        this.doFilter(0, filterBy);
        return this;
    }

    public CsvFile filter(String column, String filterBy) {
        int index = this.getColumnIndex(column);
        this.doFilter(index, filterBy);
        return this;
    }

    public CsvFile exclude(String excludeBy) {
        this.doExclude(0, excludeBy);
        return this;
    }

    public CsvFile exclude(String column, String excludeBy) {
        int index = this.getColumnIndex(column);
        this.doExclude(index, excludeBy);
        return this;
    }

    public String valueOf(String column) {
        int index = this.getColumnIndex(column);
        String[] row = this.rows.get(this.currentRow);
        return row[index];
    }

    public List<String> columnValues(String column) {
        int index = this.getColumnIndex(column);
        ArrayList<String> columnValues = new ArrayList<String>();
        for (String[] row : this.rows) {
            columnValues.add(row[index]);
        }
        return columnValues;
    }

    public String[] currentRowValues() {
        return this.rows.get(this.currentRow);
    }

    public CsvFile clone() {
        return new CsvFile(this.header, this.rows);
    }

    public CsvFile setCurrentRow(int row) {
        this.checkRowBoundaries(row);
        this.currentRow = row;
        return this;
    }

    public CsvFile setNextRow() {
        this.checkRowBoundaries(this.currentRow + 1);
        ++this.currentRow;
        return this;
    }

    public CsvFile setPreviousRow() {
        this.checkRowBoundaries(this.currentRow - 1);
        --this.currentRow;
        return this;
    }

    public boolean hasNextRow() {
        return this.currentRow < this.rows.size() - 1;
    }

    private void doFilter(int index, String filterBy) {
        ArrayList<String[]> filteredRows = new ArrayList<String[]>();
        for (String[] row : this.rows) {
            if (!row[index].equals(filterBy)) continue;
            filteredRows.add(row);
        }
        this.rows = filteredRows;
        this.currentRow = 0;
    }

    private void doExclude(int index, String excludeBy) {
        ArrayList<String[]> excludedRows = new ArrayList<String[]>();
        for (String[] row : this.rows) {
            if (!row[index].equals(excludeBy)) {
                excludedRows.add(row);
            }
            this.rows = excludedRows;
            this.currentRow = 0;
        }
    }

    private void checkRowBoundaries(int row) {
        if (row > this.rows.size() - 1) {
            throw new IndexOutOfBoundsException("New row index [" + row + "] exceeds the bounds of the CSV file.");
        }
        if (row - 1 < 0) {
            throw new IndexOutOfBoundsException("New index cannot be less than zero.");
        }
    }

    private int getColumnIndex(String column) {
        for (int i = 0; i < this.header.length; ++i) {
            if (!this.header[i].equalsIgnoreCase(column)) continue;
            return i;
        }
        throw new IllegalArgumentException("The column [" + column + "] does not exist.");
    }
}

