/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Segment;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentSender
implements ResponseCommitListener {
    private static final Logger log = LoggerFactory.getLogger(SegmentSender.class);
    final AWSXRayRecorder recorder;
    final Segment segment;

    public void beforeCommit(HttpServerExchange httpServerExchange) {
        try {
            this.attachResponseDataToSegment(httpServerExchange);
            if (this.segment.end()) {
                this.recorder.sendSegment(this.segment);
            }
        }
        catch (Throwable throwable) {
            log.error("Could not send segment " + this.segment, throwable);
        }
    }

    void attachResponseDataToSegment(HttpServerExchange httpServerExchange) {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        hashMap.put("status", httpServerExchange.getStatusCode());
        long l = httpServerExchange.getResponseContentLength();
        if (l > -1L) {
            hashMap.put("content_length", l);
        }
        this.segment.putHttp("response", hashMap);
    }

    @ConstructorProperties(value={"recorder", "segment"})
    public SegmentSender(AWSXRayRecorder aWSXRayRecorder, Segment segment) {
        this.recorder = aWSXRayRecorder;
        this.segment = segment;
    }
}

