/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.SegmentImpl;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.cloud.aws.xray.SegmentNamingStrategy;
import kikaha.cloud.smart.ServiceRegistry;

@Singleton
public class SegmentFactory {
    static final HttpString X_AMZN_TRACE_ID = new HttpString("X-Amzn-Trace-Id");
    @Inject
    AWSXRayRecorder recorder;
    @Inject
    SegmentNamingStrategy segmentNamingStrategy;
    @Inject
    ServiceRegistry.ApplicationData applicationData;

    public Segment createSegment(HttpServerExchange httpServerExchange) throws Exception {
        String string = httpServerExchange.getRequestHeaders().getFirst("X-Amzn-Trace-Id");
        TraceHeader traceHeader = string != null ? TraceHeader.fromString((String)string) : null;
        TraceHeader.SampleDecision sampleDecision = this.getSampleDecision(traceHeader, httpServerExchange);
        Segment segment = this.createSegment(this.applicationData.getName(), sampleDecision, traceHeader);
        this.attachTraceId(httpServerExchange, traceHeader, segment);
        HashMap<String, Object> hashMap = this.createRequestAttributes(httpServerExchange);
        segment.putHttp("request", hashMap);
        return segment;
    }

    TraceHeader.SampleDecision getSampleDecision(TraceHeader traceHeader, HttpServerExchange httpServerExchange) {
        TraceHeader.SampleDecision sampleDecision = TraceHeader.SampleDecision.UNKNOWN;
        if (traceHeader != null) {
            sampleDecision = traceHeader.getSampled();
        }
        if (TraceHeader.SampleDecision.UNKNOWN.equals((Object)sampleDecision) || TraceHeader.SampleDecision.REQUESTED.equals((Object)sampleDecision)) {
            boolean bl = this.recorder.getSamplingStrategy().shouldTrace(httpServerExchange.getHostName(), httpServerExchange.getRelativePath(), httpServerExchange.getRequestMethod().toString());
            sampleDecision = bl ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED;
        }
        return sampleDecision;
    }

    Segment createSegment(String string, TraceHeader.SampleDecision sampleDecision, TraceHeader traceHeader) {
        Segment segment;
        TraceID traceID;
        SamplingStrategy samplingStrategy = this.recorder.getSamplingStrategy();
        String string2 = traceHeader != null ? traceHeader.getParentId() : null;
        TraceID traceID2 = traceID = traceHeader != null ? traceHeader.getRootTraceId() : new TraceID();
        if (TraceHeader.SampleDecision.SAMPLED.equals((Object)sampleDecision)) {
            segment = this.beginSegmentFrom(string, traceID, string2);
        } else if (samplingStrategy.isForcedSamplingSupported()) {
            segment = this.beginSegmentFrom(string, traceID, string2);
            segment.setSampled(false);
        } else {
            segment = this.beginDummySegment(string, traceID);
        }
        return segment;
    }

    private Segment beginSegmentFrom(String string, TraceID traceID, String string2) {
        String string3 = this.getSegmentName(string);
        SegmentImpl segmentImpl = new SegmentImpl(this.recorder, string3, traceID);
        segmentImpl.setParentId(string2);
        return segmentImpl;
    }

    Segment beginDummySegment(String string, TraceID traceID) {
        return new SegmentImpl(this.recorder, string, traceID);
    }

    private String getSegmentName(String string) {
        try {
            return this.segmentNamingStrategy.nameForRequest(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("kikaha-cloud-aws-xray requires either a fixedName configuration or a SegmentNamingStrategy be provided. Please change your application.yml or constructor call as necessary.", nullPointerException);
        }
    }

    private HashMap<String, Object> createRequestAttributes(HttpServerExchange httpServerExchange) {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", httpServerExchange.getRelativePath());
        hashMap.put("method", httpServerExchange.getRequestMethod().toString());
        String string2 = httpServerExchange.getRequestHeaders().getFirst(Headers.USER_AGENT);
        if (string2 != null) {
            hashMap.put("user_agent", string2);
        }
        if ((string = httpServerExchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR)) != null) {
            hashMap.put("client_ip", string);
            hashMap.put("x_forwarded_for", true);
        } else {
            String string3 = httpServerExchange.getDestinationAddress().getHostString();
            hashMap.put("client_ip", string3);
        }
        return hashMap;
    }

    private void attachTraceId(HttpServerExchange httpServerExchange, TraceHeader traceHeader, Segment segment) {
        TraceHeader traceHeader2;
        if (traceHeader != null) {
            traceHeader2 = new TraceHeader(traceHeader.getRootTraceId());
            if (TraceHeader.SampleDecision.REQUESTED == traceHeader.getSampled()) {
                TraceHeader.SampleDecision sampleDecision = segment.isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED;
                traceHeader2.setSampled(sampleDecision);
            }
        } else {
            traceHeader2 = new TraceHeader(segment.getTraceId());
        }
        httpServerExchange.getResponseHeaders().put(X_AMZN_TRACE_ID, traceHeader2.toString());
    }
}

