/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.entities.SearchPattern;
import kikaha.cloud.aws.xray.SegmentNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSegmentNamingStrategy
implements SegmentNamingStrategy {
    private static final Logger log = LoggerFactory.getLogger(DynamicSegmentNamingStrategy.class);
    private String recognizedHosts;
    private String fallbackName;

    public DynamicSegmentNamingStrategy(String string) {
        this(string, "*");
    }

    public DynamicSegmentNamingStrategy(String string, String string2) {
        this.fallbackName = string;
        String string3 = this.getOverrideName();
        if (null != string3) {
            this.fallbackName = this.getOverrideName();
            log.info("AWS_XRAY_TRACING_NAME is set, overriding DynamicSegmentNamingStrategy constructor argument. Segments generated with this strategy will be named: " + this.fallbackName + " when the host header is unavilable or does not match the provided recognizedHosts pattern.");
        }
        this.recognizedHosts = string2;
    }

    @Override
    public String nameForRequest(String string) {
        return string == null && null == this.recognizedHosts || !SearchPattern.wildcardMatch((String)this.recognizedHosts, (String)string) ? this.fallbackName : string;
    }
}

