/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.contexts.LambdaSegmentContextResolver;
import com.amazonaws.xray.contexts.SegmentContextResolver;
import com.amazonaws.xray.contexts.SegmentContextResolverChain;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.cloud.aws.xray.DynamicSegmentNamingStrategy;
import kikaha.cloud.aws.xray.FixedSegmentNamingStrategy;
import kikaha.cloud.aws.xray.SegmentNamingStrategy;
import kikaha.cloud.smart.ServiceRegistry;

@Singleton
public class AmazonXRayProducer {
    private final AWSXRayRecorder recorder = AWSXRayRecorderBuilder.standard().withSegmentContextResolverChain(this.createSegmentResolverChain()).build();
    @Inject
    ServiceRegistry.ApplicationData applicationData;

    @Produces
    AWSXRayRecorder produceXRayRecorder() {
        return this.recorder;
    }

    @Produces
    SegmentNamingStrategy loadSegmentNamingStrategy() {
        String string = this.applicationData.getName();
        if (string.contains("*")) {
            return new DynamicSegmentNamingStrategy(string);
        }
        return new FixedSegmentNamingStrategy(string);
    }

    SegmentContextResolverChain createSegmentResolverChain() {
        SegmentContextResolverChain segmentContextResolverChain = new SegmentContextResolverChain();
        segmentContextResolverChain.addResolver((SegmentContextResolver)new LambdaSegmentContextResolver());
        return segmentContextResolverChain;
    }
}

