/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.cloud.aws.xray.AmazonXRayHttpHandler;
import kikaha.cloud.aws.xray.SegmentFactory;
import kikaha.config.Config;
import kikaha.core.DeploymentContext;
import kikaha.core.modules.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmazonXRayModule
implements Module {
    private static final Logger log = LoggerFactory.getLogger(AmazonXRayModule.class);
    @Inject
    AWSXRayRecorder recorder;
    @Inject
    SegmentFactory segmentFactory;
    @Inject
    Config config;

    public void load(Undertow.Builder builder, DeploymentContext deploymentContext) throws IOException {
        if (this.config.getBoolean("server.aws.x-ray.enabled")) {
            log.info("AWS X-Ray enabled.");
            HttpHandler httpHandler = deploymentContext.rootHandler();
            AmazonXRayHttpHandler amazonXRayHttpHandler = new AmazonXRayHttpHandler(this.recorder, this.segmentFactory, httpHandler);
            deploymentContext.rootHandler((HttpHandler)amazonXRayHttpHandler);
        }
    }
}

