/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Segment;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import java.beans.ConstructorProperties;
import kikaha.cloud.aws.xray.SegmentFactory;
import kikaha.cloud.aws.xray.SegmentSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonXRayHttpHandler
implements HttpHandler {
    private static final Logger log = LoggerFactory.getLogger(AmazonXRayHttpHandler.class);
    final AWSXRayRecorder recorder;
    final SegmentFactory segmentFactory;
    final HttpHandler nextHandler;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Segment segment = this.segmentFactory.createSegment(httpServerExchange);
        httpServerExchange.addResponseCommitListener((ResponseCommitListener)new SegmentSender(this.recorder, segment));
        try {
            this.nextHandler.handleRequest(httpServerExchange);
        }
        catch (Exception exception) {
            if (null != segment) {
                segment.addException((Throwable)exception);
            }
            throw exception;
        }
    }

    @ConstructorProperties(value={"recorder", "segmentFactory", "nextHandler"})
    public AmazonXRayHttpHandler(AWSXRayRecorder aWSXRayRecorder, SegmentFactory segmentFactory, HttpHandler httpHandler) {
        this.recorder = aWSXRayRecorder;
        this.segmentFactory = segmentFactory;
        this.nextHandler = httpHandler;
    }
}

