/*
 * Decompiled with CFR 0.152.
 */
package skuber.examples.deployment;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Terminated;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import skuber.api.client.package;
import skuber.examples.deployment.DeploymentExamples$delayedInit$body;
import skuber.model.Container;
import skuber.model.Container$;
import skuber.model.Pod;
import skuber.model.apps.v1.Deployment;
import skuber.model.apps.v1.Deployment$;
import skuber.model.package;
import skuber.pekkoclient.PekkoKubernetesClient;

public final class DeploymentExamples$
implements App {
    public static final DeploymentExamples$ MODULE$ = new DeploymentExamples$();
    private static String nginxDeploymentName;
    private static ActorSystem system;
    private static ExecutionContext dispatcher;
    private static PekkoKubernetesClient k8s;
    private static Future<Deployment> deployment;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new DeploymentExamples$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public String nginxDeploymentName() {
        return nginxDeploymentName;
    }

    public ActorSystem system() {
        return system;
    }

    public ExecutionContext dispatcher() {
        return dispatcher;
    }

    public PekkoKubernetesClient k8s() {
        return k8s;
    }

    public Future<Deployment> deployment() {
        return deployment;
    }

    public Future<Deployment> deployNginx(String version) {
        Tuple2 nginxLabel = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)"nginx");
        Container nginxContainer = new Container("nginx", new StringBuilder(6).append("nginx:").append(version).toString(), Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22()).exposePort(80);
        Pod.Template$.Spec nginxTemplate = Pod.Template$.Spec$.MODULE$.named("nginx").addContainer(nginxContainer).addLabel(nginxLabel);
        int desiredCount = 5;
        Deployment nginxDeployment = Deployment$.MODULE$.apply(this.nginxDeploymentName()).withReplicas(desiredCount).withTemplate(nginxTemplate);
        Predef$.MODULE$.println((Object)"Creating nginx deployment");
        Future createdDeplFut = this.k8s().create((package.ObjectResource)nginxDeployment, Deployment$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
        return createdDeplFut.recoverWith((PartialFunction)new Serializable(nginxDeployment){
            private static final long serialVersionUID = 0L;
            private final Deployment nginxDeployment$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                package.K8SException k8SException;
                A1 A1 = x1;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"It seems the deployment object already exists - retrieving latest version and updating it");
                    return (B1)DeploymentExamples$.MODULE$.k8s().get(this.nginxDeployment$1.name(), Deployment$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)curr -> {
                        Predef$.MODULE$.println((Object)"retrieved latest deployment, now updating");
                        Deployment updated = $this.nginxDeployment$1.withResourceVersion(curr.metadata().resourceVersion());
                        return DeploymentExamples$.MODULE$.k8s().update((package.ObjectResource)updated, Deployment$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
                    }, DeploymentExamples$.MODULE$.dispatcher());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                package.K8SException k8SException;
                Throwable throwable = x1;
                return throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
            }
            {
                this.nginxDeployment$1 = nginxDeployment$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(skuber.examples.deployment.DeploymentExamples$$anonfun$deployNginx$1 skuber.model.apps.v1.Deployment )}, serializedLambda);
            }
        }, this.dispatcher());
    }

    public Future<Deployment> updateNginx(String version) {
        Container updatedContainer = new Container("nginx", new StringBuilder(6).append("nginx:").append(version).toString(), Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22()).exposePort(80);
        Future currentDeployment = this.k8s().get("nginx-deployment", Deployment$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
        return currentDeployment.flatMap((Function1 & Serializable)nginxDeployment -> {
            Deployment updatedDeployment = nginxDeployment.updateContainer(updatedContainer);
            return MODULE$.k8s().update((package.ObjectResource)updatedDeployment, Deployment$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
        }, this.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$new$4(Terminated f) {
        System.exit(0);
    }

    public static final /* synthetic */ void $anonfun$new$5(Terminated f) {
        System.exit(1);
    }

    public static final /* synthetic */ void $anonfun$new$1(Deployment depl) {
        int waitingTime = 60;
        Predef$.MODULE$.println((Object)new StringBuilder(88).append("Successfully created deployment of nginx 1.7.9...now waiting ").append(waitingTime).append(" seconds before updating it").toString());
        int reportInterval = 10;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), waitingTime / reportInterval).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Thread.sleep(1000 * reportInterval);
            Predef$.MODULE$.println((Object)new StringBuilder(17).append("...").append(waitingTime - i * reportInterval).append(" seconds to go").toString());
        });
        Predef$.MODULE$.println((Object)"Updating deployment to nginx 1.9.1");
        MODULE$.updateNginx("1.9.1").onComplete((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Predef$.MODULE$.println((Object)"Update successfully requested - use'kubectl describe deployments' to monitor progress");
                Predef$.MODULE$.println((Object)"(Waiting two minutes before deleting nginx deployment)");
                Thread.sleep(120000L);
                Predef$.MODULE$.println((Object)"Deleting deployment, including its owned resources");
                Some x$1 = new Some((Object)package.DeletePropagation$.MODULE$.Foreground());
                String x$2 = package.DeleteOptions$.MODULE$.apply$default$1();
                String x$3 = package.DeleteOptions$.MODULE$.apply$default$2();
                Option x$4 = package.DeleteOptions$.MODULE$.apply$default$3();
                Option x$5 = package.DeleteOptions$.MODULE$.apply$default$4();
                package.DeleteOptions deleteOptions = new package.DeleteOptions(x$2, x$3, x$4, x$5, (Option)x$1);
                Future deleteFut = MODULE$.k8s().deleteWithOptions(MODULE$.nginxDeploymentName(), deleteOptions, Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
                Await$.MODULE$.ready((Awaitable)deleteFut, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
                Predef$.MODULE$.println((Object)"DSuccessfully completed, exiting");
                MODULE$.system().terminate().foreach((Function1 & Serializable)f -> {
                    DeploymentExamples$.$anonfun$new$4(f);
                    return BoxedUnit.UNIT;
                }, MODULE$.dispatcher());
                return BoxedUnit.UNIT;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                ex.printStackTrace();
                return MODULE$.system().terminate().map((Function1 & Serializable)f -> {
                    DeploymentExamples$.$anonfun$new$5(f);
                    return BoxedUnit.UNIT;
                }, MODULE$.dispatcher());
            }
            throw new MatchError((Object)try_);
        }, MODULE$.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$new$6(Throwable ex) {
        ex.printStackTrace();
        MODULE$.system().terminate();
        System.exit(1);
    }

    public final void delayedEndpoint$skuber$examples$deployment$DeploymentExamples$1() {
        nginxDeploymentName = "nginx-deployment";
        system = ActorSystem$.MODULE$.apply();
        dispatcher = this.system().dispatcher();
        k8s = skuber.pekkoclient.package$.MODULE$.k8sInit(this.system());
        deployment = this.deployNginx("1.7.9");
        this.deployment().foreach((Function1 & Serializable)depl -> {
            DeploymentExamples$.$anonfun$new$1(depl);
            return BoxedUnit.UNIT;
        }, this.dispatcher());
        this.deployment().failed().foreach((Function1 & Serializable)ex -> {
            DeploymentExamples$.$anonfun$new$6(ex);
            return BoxedUnit.UNIT;
        }, this.dispatcher());
    }

    private DeploymentExamples$() {
    }
}

