/*
 * Decompiled with CFR 0.152.
 */
package skuber.examples.patch;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Terminated;
import java.io.Serializable;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format;
import play.api.libs.json.Format$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import skuber.akkaclient.AkkaKubernetesClient;
import skuber.api.client.package;
import skuber.api.patch.package;
import skuber.examples.patch.PatchExamples;
import skuber.examples.patch.PatchExamples$ReplicaPatch$;
import skuber.examples.patch.PatchExamples$ReplicaSpec$;
import skuber.examples.patch.PatchExamples$delayedInit$body;
import skuber.model.Container;
import skuber.model.Container$;
import skuber.model.LabelSelector;
import skuber.model.Pod;
import skuber.model.Service;
import skuber.model.Service$;
import skuber.model.apps.v1.StatefulSet;
import skuber.model.apps.v1.StatefulSet$;
import skuber.model.package;

public final class PatchExamples$
implements App {
    public static final PatchExamples$ MODULE$ = new PatchExamples$();
    private static Format<PatchExamples.ReplicaSpec> rsFmt;
    private static Format<PatchExamples.ReplicaPatch> rpFmt;
    private static String statefulSetName;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new PatchExamples$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public Format<PatchExamples.ReplicaSpec> rsFmt() {
        return rsFmt;
    }

    public Format<PatchExamples.ReplicaPatch> rpFmt() {
        return rpFmt;
    }

    public String statefulSetName() {
        return statefulSetName;
    }

    public Future<Terminated> scaleNginx() {
        Container nginxContainer = new Container("nginx", "nginx", Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22()).exposePort(80);
        Pod.Template$.Spec nginxBaseSpec = new Pod.Template$.Spec(Pod.Template$.Spec$.MODULE$.apply$default$1(), Pod.Template$.Spec$.MODULE$.apply$default$2()).addContainer(nginxContainer);
        Map nginxStsLabels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"patch-example"), (Object)"statefulset")}));
        LabelSelector nginxStsSel = new LabelSelector((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LabelSelector.Requirement[]{new LabelSelector.IsEqualRequirement("patch-example", "statefulset")}));
        Pod.Template$.Spec nginxStsSpec = nginxBaseSpec.addLabels(nginxStsLabels);
        StatefulSet nginxStatefulSet = StatefulSet$.MODULE$.apply(this.statefulSetName()).withReplicas(4).withServiceName(this.statefulSetName()).withLabelSelector(nginxStsSel).withTemplate(nginxStsSpec);
        Service nginxStsService = Service$.MODULE$.apply((String)((StatefulSet.Spec)nginxStatefulSet.spec().get()).serviceName().get(), nginxStsLabels, 80).isHeadless();
        ActorSystem system = ActorSystem$.MODULE$.apply();
        ExecutionContextExecutor dispatcher = system.dispatcher();
        AkkaKubernetesClient k8s = skuber.akkaclient.package$.MODULE$.k8sInit(system);
        Predef$.MODULE$.println((Object)"Creating nginx stateful set");
        Future createdStsFut = k8s.create((package.ObjectResource)nginxStsService, skuber.json.format.package$.MODULE$.serviceFmt(), Service$.MODULE$.svcDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)svc -> k8s.create((package.ObjectResource)nginxStatefulSet, StatefulSet$.MODULE$.statefulSetFormat(), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)sts -> sts, (ExecutionContext)dispatcher), (ExecutionContext)dispatcher);
        Future stsFut = createdStsFut.recoverWith((PartialFunction)new Serializable(k8s, nginxStatefulSet){
            private static final long serialVersionUID = 0L;
            private final AkkaKubernetesClient k8s$1;
            private final StatefulSet nginxStatefulSet$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                package.K8SException k8SException;
                A1 A1 = x1;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"It seems the stateful set or service already exists - retrieving latest version");
                    return (B1)this.k8s$1.get(this.nginxStatefulSet$1.name(), StatefulSet$.MODULE$.statefulSetFormat(), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                package.K8SException k8SException;
                Throwable throwable = x1;
                return throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
            }
            {
                this.k8s$1 = k8s$1;
                this.nginxStatefulSet$1 = nginxStatefulSet$1;
            }
        }, (ExecutionContext)dispatcher);
        StatefulSet sts2 = (StatefulSet)Await$.MODULE$.result((Awaitable)stsFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"waiting two minutes to allow Stateful Set creation to complete before patching it");
        Thread.sleep(120000L);
        Predef$.MODULE$.println((Object)"Patching stateful set to assign replica count of 1");
        PatchExamples.ReplicaPatch singleReplicaPatch = new PatchExamples.ReplicaPatch(new PatchExamples.ReplicaSpec(1));
        JsValue singleReplicaPatchJson = Json$.MODULE$.toJson((Object)singleReplicaPatch, this.rpFmt());
        String singleReplicaPatchJsonStr = singleReplicaPatchJson.toString();
        Future patchedStsFut = k8s.patch(this.statefulSetName(), (package.Patch)singleReplicaPatch, k8s.patch$default$3(), this.rpFmt(), StatefulSet$.MODULE$.statefulSetFormat(), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc());
        StatefulSet patchedSts = (StatefulSet)Await$.MODULE$.result((Awaitable)patchedStsFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("Patched statefulset now has a desired replica count of ").append(((StatefulSet.Spec)patchedSts.spec().get()).replicas()).toString());
        Predef$.MODULE$.println((Object)"waiting 5 minutes to allow scaling to be observed before cleaning up");
        Thread.sleep(300000L);
        Predef$.MODULE$.println((Object)"will now delete StatefulSet and its service");
        Some x$1 = new Some((Object)package.DeletePropagation$.MODULE$.Foreground());
        String x$2 = package.DeleteOptions$.MODULE$.apply$default$1();
        String x$3 = package.DeleteOptions$.MODULE$.apply$default$2();
        Option x$4 = package.DeleteOptions$.MODULE$.apply$default$3();
        Option x$5 = package.DeleteOptions$.MODULE$.apply$default$4();
        Future cleanupRequested = k8s.deleteWithOptions(nginxStatefulSet.name(), new package.DeleteOptions(x$2, x$3, x$4, x$5, (Option)x$1), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)sts -> k8s.delete(nginxStsService.name(), k8s.delete$default$2(), Service$.MODULE$.svcDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)done -> {
            PatchExamples$.$anonfun$scaleNginx$4(done);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)dispatcher), (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)cleanupRequested, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"Finishing up");
        k8s.close();
        return system.terminate();
    }

    public static final /* synthetic */ PatchExamples.ReplicaSpec $anonfun$rsFmt$1(int replicas) {
        return new PatchExamples.ReplicaSpec(replicas);
    }

    public static final /* synthetic */ void $anonfun$scaleNginx$4(BoxedUnit done) {
    }

    public final void delayedEndpoint$skuber$examples$patch$PatchExamples$1() {
        OFormat underlying = (OFormat)package$.MODULE$.toInvariantFunctorOps((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("replicas")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())), OFormat$.MODULE$.invariantFunctorOFormat()).inmap((Function1 & Serializable)replicas -> PatchExamples$.$anonfun$rsFmt$1(BoxesRunTime.unboxToInt((Object)replicas)), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> PatchExamples$ReplicaSpec$.MODULE$.unapply((PatchExamples.ReplicaSpec)x$0)));
        Function1 & Serializable rfn = (Function1 & Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying.flatMap((Function1 & Serializable)v -> Reads$.MODULE$.pure((Function0 & Serializable)() -> v)).reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        };
        rsFmt = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable)o -> underlying.writes(o));
        OFormat underlying2 = (OFormat)package$.MODULE$.toInvariantFunctorOps((Object)JsPath$.MODULE$.$bslash(JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$).naming().apply("spec")).format(this.rsFmt()), OFormat$.MODULE$.invariantFunctorOFormat()).inmap((Function1 & Serializable)spec -> new PatchExamples.ReplicaPatch((PatchExamples.ReplicaSpec)spec), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> PatchExamples$ReplicaPatch$.MODULE$.unapply((PatchExamples.ReplicaPatch)x$0)));
        Function1 & Serializable rfn2 = (Function1 & Serializable)x0$2 -> {
            JsValue jsValue = x0$2;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying2.flatMap((Function1 & Serializable)v -> Reads$.MODULE$.pure((Function0 & Serializable)() -> v)).reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        };
        rpFmt = OFormat$.MODULE$.apply((Function1)rfn2, (Function1 & Serializable)o -> underlying2.writes(o));
        statefulSetName = "nginx-patch-sts";
        this.scaleNginx();
    }

    private PatchExamples$() {
    }
}

