/*
 * Decompiled with CFR 0.152.
 */
package skuber.examples.ingress;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.HttpURLConnection;
import java.net.URL;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.StdIn$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import skuber.akkaclient.AkkaKubernetesClient;
import skuber.api.client.KubernetesClient;
import skuber.api.client.package;
import skuber.examples.ingress.NginxIngress$delayedInit$body;
import skuber.model.Container;
import skuber.model.Container$;
import skuber.model.Pod;
import skuber.model.Service;
import skuber.model.Service$;
import skuber.model.apps.v1.ReplicaSet;
import skuber.model.apps.v1.ReplicaSet$;
import skuber.model.networking.Ingress;
import skuber.model.networking.Ingress$;
import skuber.model.package;
import skuber.model.package$;

public final class NginxIngress$
implements App {
    public static final NginxIngress$ MODULE$ = new NginxIngress$();
    private static int httpPort;
    private static int httpsPort;
    private static int nodeIngressHttpPort;
    private static int nodeIngressHttpsPort;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new NginxIngress$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public int httpPort() {
        return httpPort;
    }

    public int httpsPort() {
        return httpsPort;
    }

    public int nodeIngressHttpPort() {
        return nodeIngressHttpPort;
    }

    public int nodeIngressHttpsPort() {
        return nodeIngressHttpsPort;
    }

    public Tuple2<Service, ReplicaSet> buildIngressController() {
        boolean replicase = true;
        String name = "skuber-nginx-ing-ctrlr";
        Tuple2 ingressControllerPodLabel = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"skuber-example-app"), (Object)"nginx-ingress-lb");
        String controllerImage = "gcr.io/google_containers/nginx-ingress-controller:0.7";
        Container qual$1 = new Container(name, controllerImage, Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22()).withImagePullPolicy(Container.PullPolicy$.MODULE$.Always());
        String x$1 = "/healthz";
        Either x$2 = package$.MODULE$.portNumToNameablePort(10249);
        int x$3 = 30;
        int x$4 = 5;
        String x$5 = qual$1.withHttpLivenessProbe$default$5();
        Container nginxContainer = qual$1.withHttpLivenessProbe("/healthz", x$2, 30, 5, x$5).setEnvVarFromField("POD_NAME", "metadata.name").setEnvVarFromField("POD_NAMESPACE", "metadata.namespace").exposePort(this.httpPort()).exposePort(this.httpsPort()).withArgs((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/nginx-ingress-controller", "--default-backend-service=default/default-http-backend"}));
        Pod.Spec podSpec = new Pod.Spec(Pod.Spec$.MODULE$.apply$default$1(), Pod.Spec$.MODULE$.apply$default$2(), Pod.Spec$.MODULE$.apply$default$3(), Pod.Spec$.MODULE$.apply$default$4(), Pod.Spec$.MODULE$.apply$default$5(), Pod.Spec$.MODULE$.apply$default$6(), Pod.Spec$.MODULE$.apply$default$7(), Pod.Spec$.MODULE$.apply$default$8(), Pod.Spec$.MODULE$.apply$default$9(), Pod.Spec$.MODULE$.apply$default$10(), Pod.Spec$.MODULE$.apply$default$11(), Pod.Spec$.MODULE$.apply$default$12(), Pod.Spec$.MODULE$.apply$default$13(), Pod.Spec$.MODULE$.apply$default$14(), Pod.Spec$.MODULE$.apply$default$15(), Pod.Spec$.MODULE$.apply$default$16(), Pod.Spec$.MODULE$.apply$default$17(), Pod.Spec$.MODULE$.apply$default$18(), Pod.Spec$.MODULE$.apply$default$19(), Pod.Spec$.MODULE$.apply$default$20(), Pod.Spec$.MODULE$.apply$default$21(), Pod.Spec$.MODULE$.apply$default$22(), Pod.Spec$.MODULE$.apply$default$23(), Pod.Spec$.MODULE$.apply$default$24(), Pod.Spec$.MODULE$.apply$default$25(), Pod.Spec$.MODULE$.apply$default$26()).addContainer(nginxContainer).withTerminationGracePeriodSeconds(60);
        ReplicaSet rset = ReplicaSet$.MODULE$.apply(name, podSpec, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ingressControllerPodLabel})));
        Service svc = Service$.MODULE$.apply(name).withSelector(ingressControllerPodLabel).exposeOnNodePort(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.nodeIngressHttpPort())), (Object)BoxesRunTime.boxToInteger((int)this.httpPort())), "http").exposeOnNodePort(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.nodeIngressHttpsPort())), (Object)BoxesRunTime.boxToInteger((int)this.httpsPort())), "https");
        return new Tuple2((Object)svc, (Object)rset);
    }

    public Ingress buildIngress() {
        return Ingress$.MODULE$.apply("echomap").addHttpRule("foo.bar.com", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/foo"), (Object)"echoheaders-x:80")}))).addHttpRule("bar.baz.com", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/bar"), (Object)"echoheaders-y:80"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/foo"), (Object)"echoheaders-x:80")})));
    }

    public Tuple2<Service, ReplicaSet> buildDefaultBackendService() {
        Tuple2 backendPodLabel = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)"default-http-backend");
        Container qual$1 = new Container("default-http-backend", "gcr.io/google_containers/defaultbackend:1.0", Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22());
        String x$1 = "/healthz";
        Either x$2 = package$.MODULE$.portNumToNameablePort(80);
        int x$3 = 30;
        int x$4 = 5;
        String x$5 = qual$1.withHttpLivenessProbe$default$5();
        Container container = qual$1.withHttpLivenessProbe("/healthz", x$2, 30, 5, x$5).exposePort(8080).limitCPU(package$.MODULE$.strToQuantity("10m")).limitMemory(package$.MODULE$.strToQuantity("20Mi")).requestCPU(package$.MODULE$.strToQuantity("10m")).requestMemory(package$.MODULE$.strToQuantity("20Mi"));
        Pod.Spec podSpec = new Pod.Spec(Pod.Spec$.MODULE$.apply$default$1(), Pod.Spec$.MODULE$.apply$default$2(), Pod.Spec$.MODULE$.apply$default$3(), Pod.Spec$.MODULE$.apply$default$4(), Pod.Spec$.MODULE$.apply$default$5(), Pod.Spec$.MODULE$.apply$default$6(), Pod.Spec$.MODULE$.apply$default$7(), Pod.Spec$.MODULE$.apply$default$8(), Pod.Spec$.MODULE$.apply$default$9(), Pod.Spec$.MODULE$.apply$default$10(), Pod.Spec$.MODULE$.apply$default$11(), Pod.Spec$.MODULE$.apply$default$12(), Pod.Spec$.MODULE$.apply$default$13(), Pod.Spec$.MODULE$.apply$default$14(), Pod.Spec$.MODULE$.apply$default$15(), Pod.Spec$.MODULE$.apply$default$16(), Pod.Spec$.MODULE$.apply$default$17(), Pod.Spec$.MODULE$.apply$default$18(), Pod.Spec$.MODULE$.apply$default$19(), Pod.Spec$.MODULE$.apply$default$20(), Pod.Spec$.MODULE$.apply$default$21(), Pod.Spec$.MODULE$.apply$default$22(), Pod.Spec$.MODULE$.apply$default$23(), Pod.Spec$.MODULE$.apply$default$24(), Pod.Spec$.MODULE$.apply$default$25(), Pod.Spec$.MODULE$.apply$default$26()).addContainer(container).withTerminationGracePeriodSeconds(60);
        ReplicaSet rset = ReplicaSet$.MODULE$.apply("default-http-backend", podSpec, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{backendPodLabel})));
        int x$6 = 80;
        Some x$7 = new Some((Object)package$.MODULE$.portNumToNameablePort(8080));
        String x$8 = Service.Port$.MODULE$.apply$default$1();
        Enumeration.Value x$9 = Service.Port$.MODULE$.apply$default$2();
        int x$10 = Service.Port$.MODULE$.apply$default$5();
        Service svc = Service$.MODULE$.apply("default-http-backend").withSelector(backendPodLabel).exposeOnPort(new Service.Port(x$8, x$9, 80, (Option)x$7, x$10));
        return new Tuple2((Object)svc, (Object)rset);
    }

    public Tuple2<List<Service>, ReplicaSet> buildEchoheadersServices() {
        Tuple2 echoHeadersPodLabel = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)"echoheaders");
        Container container = new Container("echoheaders", "gcr.io/google_containers/echoserver:1.4", Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21(), Container$.MODULE$.apply$default$22()).exposePort(8080);
        Pod.Spec podSpec = new Pod.Spec(Pod.Spec$.MODULE$.apply$default$1(), Pod.Spec$.MODULE$.apply$default$2(), Pod.Spec$.MODULE$.apply$default$3(), Pod.Spec$.MODULE$.apply$default$4(), Pod.Spec$.MODULE$.apply$default$5(), Pod.Spec$.MODULE$.apply$default$6(), Pod.Spec$.MODULE$.apply$default$7(), Pod.Spec$.MODULE$.apply$default$8(), Pod.Spec$.MODULE$.apply$default$9(), Pod.Spec$.MODULE$.apply$default$10(), Pod.Spec$.MODULE$.apply$default$11(), Pod.Spec$.MODULE$.apply$default$12(), Pod.Spec$.MODULE$.apply$default$13(), Pod.Spec$.MODULE$.apply$default$14(), Pod.Spec$.MODULE$.apply$default$15(), Pod.Spec$.MODULE$.apply$default$16(), Pod.Spec$.MODULE$.apply$default$17(), Pod.Spec$.MODULE$.apply$default$18(), Pod.Spec$.MODULE$.apply$default$19(), Pod.Spec$.MODULE$.apply$default$20(), Pod.Spec$.MODULE$.apply$default$21(), Pod.Spec$.MODULE$.apply$default$22(), Pod.Spec$.MODULE$.apply$default$23(), Pod.Spec$.MODULE$.apply$default$24(), Pod.Spec$.MODULE$.apply$default$25(), Pod.Spec$.MODULE$.apply$default$26()).addContainer(container);
        ReplicaSet rset = ReplicaSet$.MODULE$.apply("echoheaders", podSpec, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{echoHeadersPodLabel}))).withReplicas(1);
        int x$1 = 80;
        Some x$2 = new Some((Object)package$.MODULE$.portNumToNameablePort(8080));
        String x$3 = Service.Port$.MODULE$.apply$default$1();
        Enumeration.Value x$4 = Service.Port$.MODULE$.apply$default$2();
        int x$5 = Service.Port$.MODULE$.apply$default$5();
        Service echoheadersX = Service$.MODULE$.apply("echoheaders-x").withSelector(echoHeadersPodLabel).exposeOnPort(new Service.Port(x$3, x$4, 80, (Option)x$2, x$5));
        int x$6 = 80;
        Some x$7 = new Some((Object)package$.MODULE$.portNumToNameablePort(8080));
        String x$8 = Service.Port$.MODULE$.apply$default$1();
        Enumeration.Value x$9 = Service.Port$.MODULE$.apply$default$2();
        int x$10 = Service.Port$.MODULE$.apply$default$5();
        Service echoheadersY = Service$.MODULE$.apply("echoheaders-y").withSelector(echoHeadersPodLabel).exposeOnPort(new Service.Port(x$8, x$9, 80, (Option)x$7, x$10));
        return new Tuple2((Object)new .colon.colon((Object)echoheadersX, (List)new .colon.colon((Object)echoheadersY, (List)Nil$.MODULE$)), (Object)rset);
    }

    public boolean testIngress(Ingress ingress, KubernetesClient k8s, ExecutionContext ec) {
        String string;
        int retryCount;
        int retryIntervalSeconds;
        block3: {
            String enteredAddress;
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
            retryIntervalSeconds = 3;
            retryCount = 10;
            Predef$.MODULE$.println((Object)"The next step tests the ingress rule by sending a valid HTTP request to the ingress");
            Predef$.MODULE$.println((Object)" *** The address at which the ingress can be reached depends partly on your environment");
            Predef$.MODULE$.println((Object)" *** By default we use an address we obtain from the load balaancer information on the status field ");
            Predef$.MODULE$.println((Object)" *** of the Ingress we created, if none available it defaults to 127.0.0.1");
            Predef$.MODULE$.println((Object)" *** You can override the address if it looks wrong (e.g. if using minikube, use output of 'minikube ip')");
            Option lbAddressOpt = ingress.status().flatMap((Function1 & Serializable)status -> status.loadBalancer().flatMap((Function1 & Serializable)lb -> lb.ingress().headOption().flatMap((Function1 & Serializable)headIng -> headIng.ip().orElse((Function0 & Serializable)() -> headIng.hostName()).map((Function1 & Serializable)addr -> addr))));
            String lbAddress = (String)lbAddressOpt.getOrElse((Function0 & Serializable)() -> "127.0.0.1");
            Predef$.MODULE$.print((Object)new java.lang.StringBuilder(25).append("Enter Ingress Address [").append(lbAddress).append("]:").toString());
            String string2 = enteredAddress = StdIn$.MODULE$.readLine();
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = lbAddress;
                    break block3;
                }
            }
            string = enteredAddress;
        }
        String address = string;
        return this.attempt$1(retryCount, address, retryIntervalSeconds);
    }

    public void run() {
        ActorSystem system = ActorSystem$.MODULE$.apply();
        ExecutionContextExecutor dispatcher = system.dispatcher();
        AkkaKubernetesClient k8s = skuber.akkaclient.package$.MODULE$.k8sInit(system);
        Tuple2<Service, ReplicaSet> be = this.buildDefaultBackendService();
        Service beSvc = (Service)be._1();
        ReplicaSet beRset = (ReplicaSet)be._2();
        Tuple2<List<Service>, ReplicaSet> es = this.buildEchoheadersServices();
        List esSvcs = (List)es._1();
        ReplicaSet esRset = (ReplicaSet)es._2();
        Tuple2<Service, ReplicaSet> ingCtrlr = this.buildIngressController();
        Service ingCtrlSvc = (Service)ingCtrlr._1();
        ReplicaSet ingCtrlRset = (ReplicaSet)ingCtrlr._2();
        Ingress ingressSpec = this.buildIngress();
        Predef$.MODULE$.println((Object)"Creating required services on cluster");
        Future ingress = NginxIngress$.createNonIngressResources$1(beSvc, beRset, esRset, dispatcher, k8s, esSvcs).flatMap((Function1 & Serializable)x$6 -> {
            List list = x$6;
            return NginxIngress$.createIngressController$1(ingCtrlSvc, ingCtrlRset, dispatcher, k8s).flatMap((Function1 & Serializable)x$5 -> {
                List list = x$5;
                Predef$.MODULE$.println((Object)"Waiting for 10 seconds to enable ingress controller to start...");
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$4 -> {
                    BoxedUnit boxedUnit = x$4;
                    Thread.sleep(10000L);
                    return Future$.MODULE$.successful((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$3 -> {
                        BoxedUnit boxedUnit = x$3;
                        Predef$.MODULE$.println((Object)"now creating / updating the ingress rules");
                        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT).flatMap((Function1 & Serializable)x$2 -> {
                            BoxedUnit boxedUnit = x$2;
                            return NginxIngress$.createIngress$1(ingressSpec, k8s, dispatcher).map((Function1 & Serializable)ing -> ing, (ExecutionContext)dispatcher);
                        }, (ExecutionContext)dispatcher);
                    }, (ExecutionContext)dispatcher);
                }, (ExecutionContext)dispatcher);
            }, (ExecutionContext)dispatcher);
        }, (ExecutionContext)dispatcher);
        Future done = ingress.map((Function1 & Serializable)ing -> {
            boolean succeeded = MODULE$.testIngress((Ingress)ing, (KubernetesClient)k8s, (ExecutionContext)dispatcher);
            return new Tuple2(ing, (Object)BoxesRunTime.boxToBoolean((boolean)succeeded));
        }, (ExecutionContext)dispatcher).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)NginxIngress$.$anonfun$run$9(x$7)), (ExecutionContext)dispatcher);
        done.map((Function1 & Serializable)success -> {
            NginxIngress$.$anonfun$run$10(BoxesRunTime.unboxToBoolean((Object)success));
            return BoxedUnit.UNIT;
        }, (ExecutionContext)dispatcher);
        done.failed().foreach((Function1 & Serializable)x0$1 -> {
            NginxIngress$.$anonfun$run$11(x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)dispatcher);
    }

    private final void munch$1(BufferedReader bufferedReader$1, StringBuilder sb$1) {
        while (true) {
            int n = bufferedReader$1.read();
            switch (n) {
                default: 
            }
            if (n == -1) break;
            sb$1.append((char)n);
        }
    }

    private final String httpGet$1(String ipAddress, int port, String path, String host) {
        StringBuilder sb;
        block4: {
            sb = new StringBuilder();
            String urlStr = new java.lang.StringBuilder(9).append("http://").append(ipAddress).append(":").append(port).append("/").append(path).toString();
            try {
                URL url = new URL(urlStr);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                if (urlConn == null) break block4;
                urlConn.setReadTimeout(60000);
                urlConn.setRequestProperty("Host", host);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    InputStreamReader reader = new InputStreamReader(urlConn.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    if (bufferedReader != null) {
                        this.munch$1(bufferedReader, sb);
                        bufferedReader.close();
                    }
                    break block4;
                }
                System.err.println(new java.lang.StringBuilder(19).append("...received ").append(responseCode).append(" status").toString());
                throw new RuntimeException(new java.lang.StringBuilder(42).append("Non-ok status received while calling URL: ").append(urlStr).toString());
            }
            catch (Exception ex) {
                throw new RuntimeException(new java.lang.StringBuilder(28).append("Exception while calling URL:").append(urlStr).toString(), ex);
            }
        }
        return sb.toString();
    }

    private final boolean attempt$1(int remainingAttempts, String address$1, int retryIntervalSeconds$1) {
        boolean bl;
        while (true) {
            try {
                Predef$.MODULE$.println((Object)"Testing...attempting to GET from a path that ingress should route to echoheaders service");
                String response = this.httpGet$1(address$1, this.nodeIngressHttpPort(), "foo", "foo.bar.com");
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(38).append("Testing...successfully got response: \n").append(response).toString());
                bl = true;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Testing...attempt failed: ").append(ex.getMessage()).toString());
                if (remainingAttempts > 0) {
                    Thread.sleep(retryIntervalSeconds$1 * 1000);
                    --remainingAttempts;
                    continue;
                }
                Predef$.MODULE$.println((Object)"Testing...exceeded max retry count, giving up");
                bl = false;
            }
            break;
        }
        return bl;
    }

    private static final PartialFunction ignore409$1() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                package.K8SException k8SException;
                A1 A1 = x1;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"It seems the resource  already exists - continuing");
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                package.K8SException k8SException;
                Throwable throwable = x1;
                return throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
            }
        };
    }

    private static final Future createRS$1(ReplicaSet rs, AkkaKubernetesClient k8s$1, ExecutionContextExecutor dispatcher$1) {
        return k8s$1.create((package.ObjectResource)rs, ReplicaSet$.MODULE$.replsetFormat(), ReplicaSet$.MODULE$.rsDef(), package.LoggingContext$.MODULE$.lc()).recover(NginxIngress$.ignore409$1(), (ExecutionContext)dispatcher$1);
    }

    private static final Future createSvc$1(Service svc, AkkaKubernetesClient k8s$1, ExecutionContextExecutor dispatcher$1) {
        return k8s$1.create((package.ObjectResource)svc, skuber.json.format.package$.MODULE$.serviceFmt(), Service$.MODULE$.svcDef(), package.LoggingContext$.MODULE$.lc()).recover(NginxIngress$.ignore409$1(), (ExecutionContext)dispatcher$1);
    }

    private static final PartialFunction updateIf409$1(Ingress ing, AkkaKubernetesClient k8s$1, ExecutionContextExecutor dispatcher$1) {
        return new Serializable(k8s$1, ing, dispatcher$1){
            private static final long serialVersionUID = 0L;
            private final AkkaKubernetesClient k8s$1;
            private final Ingress ing$1;
            private final ExecutionContextExecutor dispatcher$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                package.K8SException k8SException;
                A1 A1 = x1;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"Ingress already exists - updating to current rules and continuing");
                    return (B1)this.k8s$1.get(this.ing$1.name(), skuber.json.networking.format.package$.MODULE$.ingressFormat(), Ingress$.MODULE$.ingDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)curr -> {
                        Predef$.MODULE$.println((Object)"...retrieved ingress, now updating the rules");
                        package.ObjectMeta x$1 = curr.metadata();
                        String x$2 = $this.ing$1.copy$default$1();
                        String x$3 = $this.ing$1.copy$default$2();
                        Option x$4 = $this.ing$1.copy$default$4();
                        Option x$5 = $this.ing$1.copy$default$5();
                        Ingress updated = $this.ing$1.copy(x$2, x$3, x$1, x$4, x$5);
                        return $this.k8s$1.update((package.ObjectResource)updated, skuber.json.networking.format.package$.MODULE$.ingressFormat(), Ingress$.MODULE$.ingDef(), package.LoggingContext$.MODULE$.lc());
                    }, (ExecutionContext)this.dispatcher$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                package.K8SException k8SException;
                Throwable throwable = x1;
                return throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
            }
            {
                this.k8s$1 = k8s$1;
                this.ing$1 = ing$1;
                this.dispatcher$1 = dispatcher$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(skuber.examples.ingress.NginxIngress$$anonfun$updateIf409$1$1 skuber.model.networking.Ingress )}, serializedLambda);
            }
        };
    }

    private static final Future createIng$1(Ingress ing, AkkaKubernetesClient k8s$1, ExecutionContextExecutor dispatcher$1) {
        return k8s$1.create((package.ObjectResource)ing, skuber.json.networking.format.package$.MODULE$.ingressFormat(), Ingress$.MODULE$.ingDef(), package.LoggingContext$.MODULE$.lc()).recoverWith(NginxIngress$.updateIf409$1(ing, k8s$1, dispatcher$1), (ExecutionContext)dispatcher$1);
    }

    private static final Future createEchoServices$1(List esSvcs$1, ExecutionContextExecutor dispatcher$1, AkkaKubernetesClient k8s$1) {
        return Future$.MODULE$.sequence((IterableOnce)esSvcs$1.map((Function1 & Serializable)x$1 -> NginxIngress$.createSvc$1(x$1, k8s$1, dispatcher$1)), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)dispatcher$1);
    }

    private static final Future createNonIngressResources$1(Service beSvc$1, ReplicaSet beRset$1, ReplicaSet esRset$1, ExecutionContextExecutor dispatcher$1, AkkaKubernetesClient k8s$1, List esSvcs$1) {
        return Future$.MODULE$.sequence((IterableOnce)new .colon.colon((Object)NginxIngress$.createSvc$1(beSvc$1, k8s$1, dispatcher$1), (List)new .colon.colon((Object)NginxIngress$.createRS$1(beRset$1, k8s$1, dispatcher$1), (List)new .colon.colon((Object)NginxIngress$.createEchoServices$1(esSvcs$1, dispatcher$1, k8s$1), (List)new .colon.colon((Object)NginxIngress$.createRS$1(esRset$1, k8s$1, dispatcher$1), (List)Nil$.MODULE$)))), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)dispatcher$1);
    }

    private static final Future createIngressController$1(Service ingCtrlSvc$1, ReplicaSet ingCtrlRset$1, ExecutionContextExecutor dispatcher$1, AkkaKubernetesClient k8s$1) {
        return Future$.MODULE$.sequence((IterableOnce)new .colon.colon((Object)NginxIngress$.createSvc$1(ingCtrlSvc$1, k8s$1, dispatcher$1), (List)new .colon.colon((Object)NginxIngress$.createRS$1(ingCtrlRset$1, k8s$1, dispatcher$1), (List)Nil$.MODULE$)), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)dispatcher$1);
    }

    private static final Future createIngress$1(Ingress ingressSpec$1, AkkaKubernetesClient k8s$1, ExecutionContextExecutor dispatcher$1) {
        return NginxIngress$.createIng$1(ingressSpec$1, k8s$1, dispatcher$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$9(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            boolean succeeded = tuple2._2$mcZ$sp();
            return succeeded;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$run$10(boolean success) {
        if (success) {
            Predef$.MODULE$.println((Object)"Successful.");
            return;
        }
        Predef$.MODULE$.println((Object)"Failed - test unsuccessful.");
    }

    public static final /* synthetic */ void $anonfun$run$11(Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof package.K8SException) {
            package.K8SException k8SException = (package.K8SException)throwable;
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(23).append("*** FAILED with status=").append(k8SException.status()).toString());
            return;
        }
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(8).append("FAILED: ").append(throwable.getMessage()).toString());
    }

    public final void delayedEndpoint$skuber$examples$ingress$NginxIngress$1() {
        httpPort = 80;
        httpsPort = 443;
        nodeIngressHttpPort = 30080;
        nodeIngressHttpsPort = 30443;
        this.run();
    }

    private NginxIngress$() {
    }
}

