/*
 * Decompiled with CFR 0.152.
 */
package skuber.examples.scale;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Terminated;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import java.io.Serializable;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import skuber.Container;
import skuber.Container$;
import skuber.LabelSelector;
import skuber.Pod;
import skuber.Scale;
import skuber.Service;
import skuber.Service$;
import skuber.api.client.KubernetesClient;
import skuber.api.client.package;
import skuber.apps.Deployment;
import skuber.apps.Deployment$;
import skuber.apps.StatefulSet;
import skuber.apps.StatefulSet$;
import skuber.autoscaling.HorizontalPodAutoscaler;
import skuber.autoscaling.HorizontalPodAutoscaler$;
import skuber.examples.scale.ScaleExamples$delayedInit$body;
import skuber.package;
import skuber.package$;

public final class ScaleExamples$
implements App {
    public static final ScaleExamples$ MODULE$ = new ScaleExamples$();
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new ScaleExamples$delayedInit$body(MODULE$));
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public Future<Terminated> scaleNginx() {
        Container nginxContainer = new Container("nginx", "nginx", Container$.MODULE$.apply$default$3(), Container$.MODULE$.apply$default$4(), Container$.MODULE$.apply$default$5(), Container$.MODULE$.apply$default$6(), Container$.MODULE$.apply$default$7(), Container$.MODULE$.apply$default$8(), Container$.MODULE$.apply$default$9(), Container$.MODULE$.apply$default$10(), Container$.MODULE$.apply$default$11(), Container$.MODULE$.apply$default$12(), Container$.MODULE$.apply$default$13(), Container$.MODULE$.apply$default$14(), Container$.MODULE$.apply$default$15(), Container$.MODULE$.apply$default$16(), Container$.MODULE$.apply$default$17(), Container$.MODULE$.apply$default$18(), Container$.MODULE$.apply$default$19(), Container$.MODULE$.apply$default$20(), Container$.MODULE$.apply$default$21()).exposePort(80);
        Pod.Template$.Spec nginxBaseSpec = new Pod.Template$.Spec(Pod.Template$.Spec$.MODULE$.apply$default$1(), Pod.Template$.Spec$.MODULE$.apply$default$2()).addContainer(nginxContainer);
        Map nginxDeploymentLabels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale-example-type"), (Object)"deployment")}));
        LabelSelector nginxDeploymentSel = new LabelSelector((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LabelSelector.Requirement[]{new LabelSelector.IsEqualRequirement("scale-example-type", "deployment")}));
        Pod.Template$.Spec nginxDeploymentSpec = nginxBaseSpec.addLabels(nginxDeploymentLabels);
        Deployment nginxDeployment = Deployment$.MODULE$.apply("nginx-scale-depl").withReplicas(10).withLabelSelector(nginxDeploymentSel).withTemplate(nginxDeploymentSpec);
        Map nginxStsLabels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale-example-type"), (Object)"statefulset")}));
        LabelSelector nginxStsSel = new LabelSelector((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LabelSelector.Requirement[]{new LabelSelector.IsEqualRequirement("scale-example-type", "statefulset")}));
        Pod.Template$.Spec nginxStsSpec = nginxBaseSpec.addLabels(nginxStsLabels);
        StatefulSet nginxStatefulSet = StatefulSet$.MODULE$.apply("nginx-scale-sts").withReplicas(10).withServiceName("nginx-scale-sts").withLabelSelector(nginxStsSel).withTemplate(nginxStsSpec);
        Service nginxStsService = Service$.MODULE$.apply((String)((StatefulSet.Spec)nginxStatefulSet.spec().get()).serviceName().get(), nginxStsLabels, 80).isHeadless();
        ActorSystem system = ActorSystem$.MODULE$.apply();
        ActorMaterializer materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
        ExecutionContextExecutor dispatcher = system.dispatcher();
        KubernetesClient k8s = package$.MODULE$.k8sInit(system, (Materializer)materializer);
        Predef$.MODULE$.println((Object)"Creating nginx deployment");
        Future createdDeplFut = k8s.create((package.ObjectResource)nginxDeployment, skuber.json.apps.format.package$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
        Future deplFut = createdDeplFut.recoverWith((PartialFunction)new Serializable(k8s, nginxDeployment){
            private static final long serialVersionUID = 0L;
            private final KubernetesClient k8s$1;
            private final Deployment nginxDeployment$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                package.K8SException k8SException;
                A1 A1 = x1;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"It seems the deployment already exists - retrieving latest version");
                    object = this.k8s$1.get(this.nginxDeployment$1.name(), skuber.json.apps.format.package$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                package.K8SException k8SException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
                return bl;
            }
            {
                this.k8s$1 = k8s$1;
                this.nginxDeployment$1 = nginxDeployment$1;
            }
        }, (ExecutionContext)dispatcher);
        Future scaledDeploymentFut = deplFut.map((Function1 & Serializable)del -> {
            Predef$.MODULE$.println((Object)"Directly deployment down to 1 replica");
            BoxedUnit x$1 = BoxedUnit.UNIT;
            return new Tuple2(del, (Object)x$1);
        }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = k8s.getScale(nginxDeployment.name(), Deployment$.MODULE$.deployDef(), Deployment$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)currentScale -> {
                Scale downScale = currentScale.withSpecReplicas(1);
                return new Tuple2(currentScale, (Object)downScale);
            }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$7 -> {
                Tuple2 tuple2 = x$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Scale downScale = (Scale)tuple2._2();
                Future future = k8s.updateScale(nginxDeployment.name(), downScale, Deployment$.MODULE$.deployDef(), Deployment$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)scaledDown -> {
                    Predef$.MODULE$.println((Object)new StringBuilder(28).append("Scale desired = ").append(scaledDown.spec().replicas()).append(", current = ").append(((Scale.Status)scaledDown.status().get()).replicas()).toString());
                    BoxedUnit x$2 = BoxedUnit.UNIT;
                    Predef$.MODULE$.println((Object)"Now directly scale up to 4 replicas");
                    BoxedUnit x$3 = BoxedUnit.UNIT;
                    Scale upScale = scaledDown.withSpecReplicas(4);
                    return new Tuple4(scaledDown, (Object)x$2, (Object)x$3, (Object)upScale);
                }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$6 -> {
                    Tuple4 tuple4 = x$6;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    Scale upScale = (Scale)tuple4._4();
                    Future future = k8s.updateScale(nginxDeployment.name(), upScale, Deployment$.MODULE$.deployDef(), Deployment$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)scaledUp -> {
                        Predef$.MODULE$.println((Object)new StringBuilder(47).append("Scale object returned: specified = ").append(scaledUp.spec().replicas()).append(", current = ").append(((Scale.Status)scaledUp.status().get()).replicas()).toString());
                        BoxedUnit x$4 = BoxedUnit.UNIT;
                        return new Tuple2(scaledUp, (Object)x$4);
                    }, (ExecutionContext)dispatcher).map((Function1 & Serializable)x$5 -> {
                        Scale scaledUp;
                        Tuple2 tuple2 = x$5;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Scale scale = scaledUp = (Scale)tuple2._1();
                        return scale;
                    }, (ExecutionContext)dispatcher);
                    return future;
                }, (ExecutionContext)dispatcher);
                return future;
            }, (ExecutionContext)dispatcher);
            return future;
        }, (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)scaledDeploymentFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"waiting one minute to allow scaling to complete before deleting deployment");
        Thread.sleep(60000L);
        Predef$.MODULE$.println((Object)"will now delete deployment");
        Some x$1 = new Some((Object)package.DeletePropagation$.MODULE$.Foreground());
        String x$2 = package.DeleteOptions$.MODULE$.apply$default$1();
        String x$3 = package.DeleteOptions$.MODULE$.apply$default$2();
        Option x$4 = package.DeleteOptions$.MODULE$.apply$default$3();
        Option x$5 = package.DeleteOptions$.MODULE$.apply$default$4();
        Future deploymentDeletedFut = k8s.deleteWithOptions(nginxDeployment.name(), new package.DeleteOptions(x$2, x$3, x$4, x$5, (Option)x$1), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc());
        Await$.MODULE$.ready((Awaitable)deploymentDeletedFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"Creating nginx stateful set");
        Future createdStsFut = k8s.create((package.ObjectResource)nginxStsService, skuber.json.format.package$.MODULE$.serviceFmt(), Service$.MODULE$.svcDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)svc -> k8s.create((package.ObjectResource)nginxStatefulSet, StatefulSet$.MODULE$.statefulSetFormat(), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)sts -> sts, (ExecutionContext)dispatcher), (ExecutionContext)dispatcher);
        Future stsFut = createdStsFut.recoverWith((PartialFunction)new Serializable(k8s, nginxStatefulSet){
            private static final long serialVersionUID = 0L;
            private final KubernetesClient k8s$1;
            private final StatefulSet nginxStatefulSet$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                package.K8SException k8SException;
                A1 A1 = x2;
                if (A1 instanceof package.K8SException && (k8SException = (package.K8SException)A1).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409))) {
                    Predef$.MODULE$.println((Object)"It seems the stateful set or service already exists - retrieving latest version");
                    object = this.k8s$1.get(this.nginxStatefulSet$1.name(), StatefulSet$.MODULE$.statefulSetFormat(), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                package.K8SException k8SException;
                Throwable throwable = x2;
                boolean bl = throwable instanceof package.K8SException && (k8SException = (package.K8SException)throwable).status().code().contains((Object)BoxesRunTime.boxToInteger((int)409));
                return bl;
            }
            {
                this.k8s$1 = k8s$1;
                this.nginxStatefulSet$1 = nginxStatefulSet$1;
            }
        }, (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)stsFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"waiting three minutes to allow Stateful Set creation to complete before scaling it");
        Thread.sleep(300000L);
        Predef$.MODULE$.println((Object)"Directly scaling stateful set down to 1 replica");
        Future scaledStsFut = k8s.getScale(nginxStatefulSet.name(), StatefulSet$.MODULE$.stsDef(), StatefulSet$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)currentScale -> {
            Scale downScale = currentScale.withSpecReplicas(1);
            return new Tuple2(currentScale, (Object)downScale);
        }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Scale downScale = (Scale)tuple2._2();
            Future future = k8s.updateScale(nginxStatefulSet.name(), downScale, StatefulSet$.MODULE$.stsDef(), StatefulSet$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)scaledDown -> {
                Predef$.MODULE$.println((Object)new StringBuilder(28).append("Scale desired = ").append(scaledDown.spec().replicas()).append(", current = ").append(((Scale.Status)scaledDown.status().get()).replicas()).toString());
                BoxedUnit x$9 = BoxedUnit.UNIT;
                Predef$.MODULE$.println((Object)"Now directly scaling it up to 4 replicas");
                BoxedUnit x$10 = BoxedUnit.UNIT;
                return new Tuple3(scaledDown, (Object)x$9, (Object)x$10);
            }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$13 -> {
                Tuple3 tuple3 = x$13;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Scale scaledDown = (Scale)tuple3._1();
                Future future = k8s.updateScale(nginxStatefulSet.name(), scaledDown.withSpecReplicas(4), StatefulSet$.MODULE$.stsDef(), StatefulSet$.MODULE$.scDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)scaledUp -> {
                    Predef$.MODULE$.println((Object)new StringBuilder(28).append("Scale desired = ").append(scaledUp.spec().replicas()).append(", current = ").append(((Scale.Status)scaledUp.status().get()).replicas()).toString());
                    BoxedUnit x$11 = BoxedUnit.UNIT;
                    return new Tuple2(scaledUp, (Object)x$11);
                }, (ExecutionContext)dispatcher).map((Function1 & Serializable)x$12 -> {
                    Scale scaledUp;
                    Tuple2 tuple2 = x$12;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Scale scale = scaledUp = (Scale)tuple2._1();
                    return scale;
                }, (ExecutionContext)dispatcher);
                return future;
            }, (ExecutionContext)dispatcher);
            return future;
        }, (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)scaledStsFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"waiting 10 minutes to allow scaling down to complete before deleting the StatefulSet");
        Thread.sleep(600000L);
        Predef$.MODULE$.println((Object)"will now delete StatefulSet and its service");
        Some x$6 = new Some((Object)package.DeletePropagation$.MODULE$.Foreground());
        String x$7 = package.DeleteOptions$.MODULE$.apply$default$1();
        String x$82 = package.DeleteOptions$.MODULE$.apply$default$2();
        Option x$9 = package.DeleteOptions$.MODULE$.apply$default$3();
        Option x$10 = package.DeleteOptions$.MODULE$.apply$default$4();
        Future stsDelFut = k8s.deleteWithOptions(nginxStatefulSet.name(), new package.DeleteOptions(x$7, x$82, x$9, x$10, (Option)x$6), StatefulSet$.MODULE$.stsDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)sts -> k8s.delete(nginxStsService.name(), k8s.delete$default$2(), Service$.MODULE$.svcDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)done -> {
            ScaleExamples$.$anonfun$scaleNginx$18(done);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)dispatcher), (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)stsDelFut, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"Recreating deployment for use with HPAS");
        Future autoscaleDone = k8s.create((package.ObjectResource)nginxDeployment, skuber.json.apps.format.package$.MODULE$.depFormat(), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)depl -> {
            Predef$.MODULE$.println((Object)"Now creating a HorizontalPodAutoscaler to automatically scale the replicas");
            BoxedUnit x$15 = BoxedUnit.UNIT;
            Predef$.MODULE$.println((Object)"This should cause the replica count to fall to 8 or below");
            BoxedUnit x$16 = BoxedUnit.UNIT;
            HorizontalPodAutoscaler hpas = HorizontalPodAutoscaler$.MODULE$.scale(depl).withMinReplicas(2).withMaxReplicas(8).withCPUTargetUtilization(80);
            return new Tuple4(depl, (Object)x$15, (Object)x$16, (Object)hpas);
        }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$20 -> {
            Tuple4 tuple4 = x$20;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Deployment depl = (Deployment)tuple4._1();
            HorizontalPodAutoscaler hpas = (HorizontalPodAutoscaler)tuple4._4();
            Future future = k8s.create((package.ObjectResource)hpas, HorizontalPodAutoscaler$.MODULE$.hpasFmt(), HorizontalPodAutoscaler$.MODULE$.hpasDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)hpa -> {
                Predef$.MODULE$.println((Object)"Successfully created horizontal pod autoscaler");
                Predef$.MODULE$.println((Object)"waiting one minute to allow scaling to progress before cleaning up");
                Thread.sleep(60000L);
                Predef$.MODULE$.println((Object)"will now delete hpa and deployment");
                BoxedUnit x$17 = BoxedUnit.UNIT;
                return new Tuple2(hpa, (Object)x$17);
            }, (ExecutionContext)dispatcher).flatMap((Function1 & Serializable)x$19 -> {
                Tuple2 tuple2 = x$19;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future future = k8s.delete(hpas.name(), k8s.delete$default$2(), HorizontalPodAutoscaler$.MODULE$.hpasDef(), package.LoggingContext$.MODULE$.lc()).flatMap((Function1 & Serializable)x$18 -> {
                    BoxedUnit boxedUnit = x$18;
                    Some x$11 = new Some((Object)package.DeletePropagation$.MODULE$.Foreground());
                    String x$12 = package.DeleteOptions$.MODULE$.apply$default$1();
                    String x$13 = package.DeleteOptions$.MODULE$.apply$default$2();
                    Option x$14 = package.DeleteOptions$.MODULE$.apply$default$3();
                    Option x$15 = package.DeleteOptions$.MODULE$.apply$default$4();
                    Future future = k8s.deleteWithOptions(depl.name(), new package.DeleteOptions(x$12, x$13, x$14, x$15, (Option)x$11), Deployment$.MODULE$.deployDef(), package.LoggingContext$.MODULE$.lc()).map((Function1 & Serializable)done -> {
                        ScaleExamples$.$anonfun$scaleNginx$24(done);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)dispatcher);
                    return future;
                }, (ExecutionContext)dispatcher);
                return future;
            }, (ExecutionContext)dispatcher);
            return future;
        }, (ExecutionContext)dispatcher);
        Await$.MODULE$.ready((Awaitable)autoscaleDone, (Duration)Duration$.MODULE$.Inf());
        Predef$.MODULE$.println((Object)"Finishing up");
        k8s.close();
        return system.terminate();
    }

    public static final /* synthetic */ void $anonfun$scaleNginx$18(BoxedUnit done) {
    }

    public static final /* synthetic */ void $anonfun$scaleNginx$24(BoxedUnit done) {
    }

    public final void delayedEndpoint$skuber$examples$scale$ScaleExamples$1() {
        this.scaleNginx();
    }

    private ScaleExamples$() {
    }
}

