/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients.cmdClient;

import io.skodjob.testframe.clients.KubeClusterException;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.executor.Exec;
import io.skodjob.testframe.executor.ExecResult;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCmdKubeClient<K extends BaseCmdKubeClient<K>>
implements KubeCmdClient<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCmdKubeClient.class);
    private static final String CREATE = "create";
    private static final String APPLY = "apply";
    private static final String DELETE = "delete";
    private static final String REPLACE = "replace";
    private static final String PROCESS = "process";
    private static final String GET = "get";
    protected String config;
    String namespace = this.defaultNamespace();
    private static final Context NOOP = new Context();

    protected BaseCmdKubeClient(String config) {
        this.config = config;
    }

    @Override
    public abstract String cmd();

    @Override
    public K deleteByName(String resourceType, String resourceName) {
        Exec.exec(this.namespacedCommand(DELETE, resourceType, resourceName));
        return (K)this;
    }

    protected Context defaultContext() {
        return NOOP;
    }

    protected Context adminContext() {
        return this.defaultContext();
    }

    protected List<String> namespacedCommand(String ... rest) {
        ArrayList<String> cmd = new ArrayList<String>(List.of("--namespace", this.namespace));
        cmd.addAll(Arrays.asList(rest));
        return this.command(cmd);
    }

    @Override
    public String get(String resource, String resourceName) {
        return Exec.exec(this.namespacedCommand(GET, resource, resourceName, "-o", "yaml")).out();
    }

    @Override
    public String getEvents() {
        return Exec.exec(this.namespacedCommand(GET, "events")).out();
    }

    @Override
    public K create(File ... files) {
        try (Context context = this.defaultContext();){
            Map<File, ExecResult> execResults = this.execRecursive(CREATE, files, Comparator.comparing(File::getName).reversed());
            for (Map.Entry<File, ExecResult> entry : execResults.entrySet()) {
                if (entry.getValue().exitStatus()) continue;
                LOGGER.warn("Failed to create {}!", (Object)entry.getKey().getAbsolutePath());
                LOGGER.debug(entry.getValue().err());
            }
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K apply(File ... files) {
        try (Context context = this.defaultContext();){
            Map<File, ExecResult> execResults = this.execRecursive(APPLY, files, Comparator.comparing(File::getName).reversed());
            for (Map.Entry<File, ExecResult> entry : execResults.entrySet()) {
                if (entry.getValue().exitStatus()) continue;
                LOGGER.warn("Failed to apply {}!", (Object)entry.getKey().getAbsolutePath());
                LOGGER.debug(entry.getValue().err());
            }
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K delete(File ... files) {
        try (Context context = this.defaultContext();){
            Map<File, ExecResult> execResults = this.execRecursive(DELETE, files, Comparator.comparing(File::getName).reversed());
            for (Map.Entry<File, ExecResult> entry : execResults.entrySet()) {
                if (entry.getValue().exitStatus()) continue;
                LOGGER.warn("Failed to delete {}!", (Object)entry.getKey().getAbsolutePath());
                LOGGER.debug(entry.getValue().err());
            }
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    private Map<File, ExecResult> execRecursive(String subcommand, File[] files, Comparator<File> cmp) {
        HashMap<File, ExecResult> execResults = new HashMap<File, ExecResult>(25);
        for (File f : files) {
            if (f.isFile()) {
                if (!f.getName().endsWith(".yaml")) continue;
                execResults.put(f, Exec.exec(null, this.namespacedCommand(subcommand, "-f", f.getAbsolutePath()), 0, false, false));
                continue;
            }
            if (f.isDirectory()) {
                File[] children = f.listFiles();
                if (children == null) continue;
                Arrays.sort(children, cmp);
                execResults.putAll(this.execRecursive(subcommand, children, cmp));
                continue;
            }
            if (f.exists()) continue;
            throw new RuntimeException(new NoSuchFileException(f.getPath()));
        }
        return execResults;
    }

    @Override
    public K replace(File ... files) {
        try (Context context = this.defaultContext();){
            Map<File, ExecResult> execResults = this.execRecursive(REPLACE, files, Comparator.comparing(File::getName));
            for (Map.Entry<File, ExecResult> entry : execResults.entrySet()) {
                if (entry.getValue().exitStatus()) continue;
                LOGGER.warn("Failed to replace {}!", (Object)entry.getKey().getAbsolutePath());
                LOGGER.debug(entry.getValue().err());
            }
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K applyContentInNamespace(String yamlContent) {
        try (Context context = this.defaultContext();){
            Exec.exec(yamlContent, this.namespacedCommand(APPLY, "-f", "-"));
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K deleteContentInNamespace(String yamlContent) {
        try (Context context = this.defaultContext();){
            Exec.exec(yamlContent, this.namespacedCommand(DELETE, "-f", "-"), 0, true, false);
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K applyContent(String yamlContent) {
        try (Context context = this.defaultContext();){
            Exec.exec(yamlContent, this.command(Arrays.asList(APPLY, "-f", "-")), 0, true, true);
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K deleteContent(String yamlContent) {
        try (Context context = this.defaultContext();){
            Exec.exec(yamlContent, this.command(Arrays.asList(DELETE, "-f", "-")), 0, true, false);
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public K createNamespace(String name) {
        try (Context context = this.adminContext();){
            Exec.exec(this.namespacedCommand(CREATE, "namespace", name));
        }
        return (K)this;
    }

    @Override
    public K deleteNamespace(String name) {
        try (Context context = this.adminContext();){
            Exec.exec(null, this.namespacedCommand(DELETE, "namespace", name), 0, true, false);
        }
        return (K)this;
    }

    @Override
    public K scaleByName(String kind, String name, int replicas) {
        try (Context context = this.defaultContext();){
            Exec.exec(null, this.namespacedCommand("scale", kind, name, "--replicas", Integer.toString(replicas)));
            BaseCmdKubeClient baseCmdKubeClient = this;
            return (K)baseCmdKubeClient;
        }
    }

    @Override
    public ExecResult execInPod(String pod, String ... command) {
        List<String> cmd = this.namespacedCommand("exec", pod, "--");
        cmd.addAll(Arrays.asList(command));
        return Exec.exec(cmd);
    }

    @Override
    public ExecResult execInPodContainer(String pod, String container, String ... command) {
        return this.execInPodContainer(true, pod, container, command);
    }

    @Override
    public ExecResult execInPodContainer(boolean logToOutput, String pod, String container, String ... command) {
        List<String> cmd = this.namespacedCommand("exec", pod, "-c", container, "--");
        cmd.addAll(Arrays.asList(command));
        return Exec.exec(null, cmd, 0, logToOutput);
    }

    @Override
    public ExecResult exec(String ... command) {
        return this.exec(true, command);
    }

    @Override
    public ExecResult exec(boolean throwError, String ... command) {
        return this.exec(throwError, true, command);
    }

    @Override
    public ExecResult exec(boolean throwError, boolean logToOutput, String ... command) {
        List<String> cmd = this.command(Arrays.asList(command));
        return Exec.exec(null, cmd, 0, logToOutput, throwError);
    }

    @Override
    public ExecResult exec(boolean throwError, boolean logToOutput, int timeout, String ... command) {
        List<String> cmd = this.command(Arrays.asList(command));
        return Exec.exec(null, cmd, timeout, logToOutput, throwError);
    }

    @Override
    public ExecResult execInCurrentNamespace(String ... commands) {
        return Exec.exec(this.namespacedCommand(commands));
    }

    @Override
    public ExecResult execInCurrentNamespace(boolean logToOutput, String ... commands) {
        return Exec.exec(null, this.namespacedCommand(commands), 0, logToOutput);
    }

    public String toString() {
        return this.cmd();
    }

    @Override
    public List<String> list(String resourceType) {
        return Arrays.stream(Exec.exec(this.namespacedCommand(GET, resourceType, "-o", "jsonpath={range .items[*]}{.metadata.name} ")).out().trim().split(" +")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public String getResourceAsJson(String resourceType, String resourceName) {
        return Exec.exec(this.namespacedCommand(GET, resourceType, resourceName, "-o", "json")).out();
    }

    @Override
    public String getResourceAsYaml(String resourceType, String resourceName) {
        return Exec.exec(this.namespacedCommand(GET, resourceType, resourceName, "-o", "yaml")).out();
    }

    @Override
    public String getResourcesAsYaml(String resourceType) {
        return Exec.exec(this.namespacedCommand(GET, resourceType, "-o", "yaml")).out();
    }

    @Override
    public void createResourceAndApply(String template, Map<String, String> params) {
        List<String> cmd = this.namespacedCommand(PROCESS, template, "-l", "app=" + template, "-o", "yaml");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            cmd.add("-p");
            cmd.add(entry.getKey() + "=" + entry.getValue());
        }
        String yaml = Exec.exec(cmd).out();
        this.applyContentInNamespace(yaml);
    }

    @Override
    public String describe(String resourceType, String resourceName) {
        return Exec.exec(this.namespacedCommand("describe", resourceType, resourceName)).out();
    }

    @Override
    public String logs(String pod, String container) {
        String[] args = container != null ? new String[]{"logs", pod, "-c", container} : new String[]{"logs", pod};
        return Exec.exec(this.namespacedCommand(args)).out();
    }

    @Override
    public String searchInLog(String resourceType, String resourceName, long sinceSeconds, String ... grepPattern) {
        try {
            return Exec.exec("bash", "-c", String.join((CharSequence)" ", this.namespacedCommand("logs", resourceType + "/" + resourceName, "--since=" + sinceSeconds + "s", "|", "grep", " -e " + String.join((CharSequence)" -e ", grepPattern), "-B", "1"))).out();
        }
        catch (KubeClusterException e) {
            if (e.result != null && e.result.returnCode() == 1) {
                LOGGER.info("{} not found", Arrays.stream(grepPattern).toList());
            } else {
                LOGGER.error("Caught exception while searching {} in logs", Arrays.stream(grepPattern).toList());
            }
            return "";
        }
    }

    @Override
    public String searchInLog(String resourceType, String resourceName, String resourceContainer, long sinceSeconds, String ... grepPattern) {
        try {
            return Exec.exec("bash", "-c", String.join((CharSequence)" ", this.namespacedCommand("logs", resourceType + "/" + resourceName, "-c " + resourceContainer, "--since=" + sinceSeconds + "s", "|", "grep", " -e " + String.join((CharSequence)" -e ", grepPattern), "-B", "1"))).out();
        }
        catch (KubeClusterException e) {
            if (e.result != null && e.result.exitStatus()) {
                LOGGER.info("{} not found", Arrays.stream(grepPattern).toList());
            } else {
                LOGGER.error("Caught exception while searching {} in logs", Arrays.stream(grepPattern).toList());
            }
            return "";
        }
    }

    @Override
    public List<String> listResourcesByLabel(String resourceType, String label) {
        return Arrays.asList(Exec.exec(this.namespacedCommand(GET, resourceType, "-l", label, "-o", "jsonpath={range .items[*]}{.metadata.name} ")).out().split("\\s+"));
    }

    private List<String> command(List<String> rest) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.cmd());
        if (this.config != null) {
            result.add("--kubeconfig");
            result.add(this.config);
        }
        result.addAll(rest);
        return result;
    }

    @Override
    public K process(Map<String, String> parameters, String file, Consumer<String> c) {
        List<String> command = this.command(Arrays.asList(PROCESS, "-f", file));
        command.addAll(parameters.entrySet().stream().map(e -> "-p " + (String)e.getKey() + "=" + (String)e.getValue()).toList());
        c.accept(Exec.exec(null, command, 0, false).out());
        return (K)this;
    }

    protected static class Context
    implements AutoCloseable {
        protected Context() {
        }

        @Override
        public void close() {
        }
    }
}

