/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ConfigMapResource
implements NamespacedResourceType<ConfigMap> {
    private final MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> client = KubeResourceManager.getKubeClient().getClient().configMaps();

    public String getKind() {
        return "ConfigMap";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void createInNamespace(String namespaceName, ConfigMap resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, ConfigMap resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<ConfigMap> editor) {
        ConfigMap toBeUpdated = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.updateInNamespace(namespaceName, toBeUpdated);
    }

    public void create(ConfigMap resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(ConfigMap resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<ConfigMap> editor) {
        ConfigMap toBeUpdated = (ConfigMap)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(ConfigMap resource) {
        return resource != null;
    }

    public boolean waitForDeletion(ConfigMap resource) {
        return resource == null;
    }
}

