/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class NetworkPolicyResource
implements NamespacedResourceType<NetworkPolicy> {
    private final MixedOperation<NetworkPolicy, NetworkPolicyList, Resource<NetworkPolicy>> client = KubeResourceManager.getKubeClient().getClient().network().networkPolicies();

    public String getKind() {
        return "NetworkPolicy";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(NetworkPolicy resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(NetworkPolicy resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<NetworkPolicy> editor) {
        NetworkPolicy toBeUpdated = (NetworkPolicy)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(NetworkPolicy resource) {
        return resource != null;
    }

    public boolean waitForDeletion(NetworkPolicy resource) {
        return resource == null;
    }

    public void createInNamespace(String namespaceName, NetworkPolicy resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, NetworkPolicy resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<NetworkPolicy> editor) {
        NetworkPolicy toBeReplaced = (NetworkPolicy)((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeReplaced);
        this.updateInNamespace(namespaceName, toBeReplaced);
    }
}

