/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class JobResource
implements NamespacedResourceType<Job> {
    private final MixedOperation<Job, JobList, ScalableResource<Job>> client = KubeResourceManager.getKubeClient().getClient().batch().v1().jobs();

    public String getKind() {
        return "Job";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void createInNamespace(String namespaceName, Job resource) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, Job resource) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<Job> editor) {
        Job toBeUpdated = (Job)((ScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.updateInNamespace(namespaceName, toBeUpdated);
    }

    public void create(Job resource) {
        ((ScalableResource)this.client.resource((Object)resource)).create();
    }

    public void update(Job resource) {
        ((ScalableResource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((ScalableResource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<Job> editor) {
        Job toBeUpdated = (Job)((ScalableResource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(Job resource) {
        return ((ScalableResource)this.client.resource((Object)resource)).isReady();
    }

    public boolean waitForDeletion(Job resource) {
        return resource == null;
    }
}

