/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe;

import io.skodjob.testframe.LoggerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class TestFrameEnv {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestFrameEnv.class);
    private static final Map<String, String> VALUES = new HashMap<String, String>();
    private static final Map<String, Object> YAML_DATA = TestFrameEnv.loadConfigurationFile();
    private static final String CONFIG_FILE_PATH_ENV = "ENV_FILE";
    private static final String CLIENT_TYPE_ENV = "CLIENT_TYPE";
    private static final String TOKEN_ENV = "KUBE_TOKEN";
    private static final String URL_ENV = "KUBE_URL";
    public static final String USER_PATH = System.getProperty("user.dir");
    public static final String CLIENT_TYPE = TestFrameEnv.getOrDefault("CLIENT_TYPE", "kubectl");
    public static final String KUBE_TOKEN = TestFrameEnv.getOrDefault("KUBE_TOKEN", null);
    public static final String KUBE_URL = TestFrameEnv.getOrDefault("KUBE_URL", null);

    private TestFrameEnv() {
    }

    public static void print() {
    }

    private static String getOrDefault(String varName, String defaultValue) {
        return TestFrameEnv.getOrDefault(varName, String::toString, defaultValue);
    }

    private static <T> T getOrDefault(String var, Function<String, T> converter, T defaultValue) {
        String value = System.getenv(var) != null ? System.getenv(var) : (Objects.requireNonNull(YAML_DATA).get(var) != null ? YAML_DATA.get(var).toString() : null);
        T returnValue = defaultValue;
        if (value != null) {
            returnValue = converter.apply(value);
        }
        VALUES.put(var, String.valueOf(returnValue));
        return returnValue;
    }

    private static Map<String, Object> loadConfigurationFile() {
        String config = System.getenv().getOrDefault(CONFIG_FILE_PATH_ENV, Paths.get(System.getProperty("user.dir"), "config.yaml").toAbsolutePath().toString());
        Yaml yaml = new Yaml();
        try {
            File yamlFile = new File(config).getAbsoluteFile();
            return (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
        }
        catch (IOException ex) {
            LOGGER.info("Yaml configuration not provided or does not exist");
            return Collections.emptyMap();
        }
    }

    static {
        String debugFormat = "{}: {}";
        LoggerUtils.logSeparator("-", 30);
        LOGGER.info("Used environment variables:");
        VALUES.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            if (!Objects.equals(entry.getValue(), "null")) {
                LOGGER.info(debugFormat, entry.getKey(), entry.getValue());
            }
        });
        LoggerUtils.logSeparator("-", 30);
    }
}

