/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class SecretResource
implements NamespacedResourceType<Secret> {
    private final MixedOperation<Secret, SecretList, Resource<Secret>> client = KubeResourceManager.getKubeClient().getClient().secrets();

    public String getKind() {
        return "Secret";
    }

    public void create(Secret resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void createInNamespace(String namespaceName, Secret resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void update(Secret resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void updateInNamespace(String namespaceName, Secret resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<Secret> editor) {
        Secret toBeReplaced = (Secret)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeReplaced);
        this.update(toBeReplaced);
    }

    public boolean waitForReadiness(Secret resource) {
        return false;
    }

    public boolean waitForDeletion(Secret resource) {
        return false;
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<Secret> editor) {
        Secret toBeReplaced = (Secret)((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeReplaced);
        this.updateInNamespace(namespaceName, toBeReplaced);
    }
}

