/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class RoleBindingResource
implements NamespacedResourceType<RoleBinding> {
    private final MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> client = KubeResourceManager.getKubeClient().getClient().rbac().roleBindings();

    public String getKind() {
        return "RoleBinding";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(RoleBinding resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(RoleBinding resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<RoleBinding> editor) {
        RoleBinding toBeUpdated = (RoleBinding)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(RoleBinding resource) {
        return resource != null;
    }

    public boolean waitForDeletion(RoleBinding resource) {
        return resource == null;
    }

    public void createInNamespace(String namespaceName, RoleBinding resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, RoleBinding resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<RoleBinding> editor) {
        RoleBinding toBeReplaced = (RoleBinding)((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeReplaced);
        this.updateInNamespace(namespaceName, toBeReplaced);
    }
}

