/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class NamespaceResource
implements ResourceType<Namespace> {
    private final NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> client = KubeResourceManager.getKubeClient().getClient().namespaces();

    public String getKind() {
        return "Namespace";
    }

    public NonNamespaceOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(String namespaceName) {
        Namespace namespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespaceName)).endMetadata()).build();
        this.create(namespace);
    }

    public void create(Namespace resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(Namespace resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<Namespace> editor) {
        Namespace toBeUpdated = (Namespace)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(Namespace resource) {
        return resource != null;
    }

    public boolean waitForDeletion(Namespace resource) {
        return resource == null;
    }
}

