/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class LeaseResource
implements NamespacedResourceType<Lease> {
    private MixedOperation<Lease, LeaseList, Resource<Lease>> client = KubeResourceManager.getKubeClient().getClient().leases();

    public String getKind() {
        return "Lease";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Lease resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(Lease resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((Resource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<Lease> editor) {
        Lease toBeUpdated = (Lease)((Resource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(Lease resource) {
        return ((Resource)this.client.resource((Object)resource)).isReady();
    }

    public boolean waitForDeletion(Lease resource) {
        return resource == null;
    }

    public void createInNamespace(String namespaceName, Lease resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, Lease resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<Lease> editor) {
        Lease toBeReplaced = (Lease)((Resource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeReplaced);
        this.updateInNamespace(namespaceName, toBeReplaced);
    }
}

