/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class DeploymentResource
implements NamespacedResourceType<Deployment> {
    private final MixedOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>> client = KubeResourceManager.getKubeClient().getClient().apps().deployments();

    public String getKind() {
        return "Deployment";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(Deployment resource) {
        ((RollableScalableResource)this.client.resource((Object)resource)).create();
    }

    public void update(Deployment resource) {
        ((RollableScalableResource)this.client.resource((Object)resource)).update();
    }

    public void delete(String resourceName) {
        ((RollableScalableResource)this.client.withName(resourceName)).delete();
    }

    public void replace(String resourceName, Consumer<Deployment> editor) {
        Deployment toBeUpdated = (Deployment)((RollableScalableResource)this.client.withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean waitForReadiness(Deployment resource) {
        return ((RollableScalableResource)this.client.resource((Object)resource)).isReady();
    }

    public boolean waitForDeletion(Deployment resource) {
        return resource == null;
    }

    public void createInNamespace(String namespaceName, Deployment resource) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).create();
    }

    public void updateInNamespace(String namespaceName, Deployment resource) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).resource((Object)resource)).update();
    }

    public void deleteFromNamespace(String namespaceName, String resourceName) {
        ((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).delete();
    }

    public void replaceInNamespace(String namespaceName, String resourceName, Consumer<Deployment> editor) {
        Deployment toBeUpdated = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.inNamespace(namespaceName)).withName(resourceName)).get();
        editor.accept(toBeUpdated);
        this.updateInNamespace(namespaceName, toBeUpdated);
    }
}

