/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestFrameUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestFrameUtils.class);
    public static final int DEFAULT_TIMEOUT_DURATION = 30;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;

    private TestFrameUtils() {
    }

    public static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = TestFrameUtils.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }

    public static <T> T configFromYaml(String yamlFile, Class<T> c) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return (T)mapper.readValue(yamlFile, c);
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T runUntilPass(int retry, Callable<T> fn) {
        for (int i = 0; i < retry; ++i) {
            try {
                LOGGER.debug("Running Callable, attempt: {}", (Object)i);
                return fn.call();
            }
            catch (Error | Exception ex) {
                LOGGER.warn("Callable failed: {}", (Object)ex.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalStateException(String.format("Callable did not pass in %s attempts", retry));
    }
}

