/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.executor.Exec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class KubeClient {
    private KubernetesClient client;
    private String kubeconfigPath;

    public KubeClient() {
        Config config = this.getConfig();
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    void testReconnect(Config config) {
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    public OpenShiftClient getOpenShiftClient() {
        return (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
    }

    public String getKubeconfigPath() {
        return this.kubeconfigPath;
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return this.readResourcesFromFile(Files.newInputStream(file, new OpenOption[0]));
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            List list = this.client.load(is).items();
            return list;
        }
    }

    private Config getConfig() {
        if (TestFrameEnv.KUBE_USERNAME != null && TestFrameEnv.KUBE_PASSWORD != null && TestFrameEnv.KUBE_URL != null) {
            this.kubeconfigPath = this.createLocalKubeconfig();
            return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withUsername(TestFrameEnv.KUBE_USERNAME)).withPassword(TestFrameEnv.KUBE_PASSWORD)).withMasterUrl(TestFrameEnv.KUBE_URL)).withDisableHostnameVerification(true)).withTrustCerts(true)).build();
        }
        if (TestFrameEnv.KUBE_URL != null && TestFrameEnv.KUBE_TOKEN != null) {
            this.kubeconfigPath = this.createLocalKubeconfig();
            return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withOauthToken(TestFrameEnv.KUBE_TOKEN)).withMasterUrl(TestFrameEnv.KUBE_URL)).withDisableHostnameVerification(true)).withTrustCerts(true)).build();
        }
        return Config.autoConfigure((String)System.getenv().getOrDefault("KUBE_CONTEXT", null));
    }

    private String createLocalKubeconfig() {
        try {
            if (TestFrameEnv.CLIENT_TYPE.equals("oc")) {
                if (TestFrameEnv.KUBE_URL != null && TestFrameEnv.KUBE_TOKEN != null) {
                    this.createLocalOcKubeconfig(TestFrameEnv.KUBE_TOKEN, TestFrameEnv.KUBE_URL);
                } else {
                    this.createLocalOcKubeconfig(TestFrameEnv.KUBE_USERNAME, TestFrameEnv.KUBE_PASSWORD, TestFrameEnv.KUBE_URL);
                }
            } else if (TestFrameEnv.KUBE_URL != null && TestFrameEnv.KUBE_TOKEN != null) {
                this.createLocalKubectlContext(TestFrameEnv.KUBE_TOKEN, TestFrameEnv.KUBE_URL);
            } else {
                this.createLocalKubectlContext(TestFrameEnv.KUBE_USERNAME, TestFrameEnv.KUBE_PASSWORD, TestFrameEnv.KUBE_URL);
            }
            return TestFrameEnv.USER_PATH + "/test.kubeconfig";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void createLocalOcKubeconfig(String username, String password, String apiUrl) {
        Exec.exec(null, Arrays.asList("oc", "login", "-u", username, "-p", password, "--insecure-skip-tls-verify", "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig", apiUrl), 0, false, true);
    }

    private void createLocalOcKubeconfig(String token, String apiUrl) {
        Exec.exec(null, Arrays.asList("oc", "login", "--token", token, "--insecure-skip-tls-verify", "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig", apiUrl), 0, false, true);
    }

    private void createLocalKubectlContext(String username, String password, String apiUrl) {
        Exec.exec(null, Arrays.asList("kubectl", "config", "set-credentials", "test-user", "--username", username, "--password", password, "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig"), 0, false, true);
        this.buildKubectlContext(apiUrl);
    }

    private void createLocalKubectlContext(String token, String apiUrl) {
        Exec.exec(null, Arrays.asList("kubectl", "config", "set-credentials", "test-user", "--token", token, "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig"), 0, false, true);
        this.buildKubectlContext(apiUrl);
    }

    private void buildKubectlContext(String apiUrl) {
        Exec.exec(null, Arrays.asList("kubectl", "config", "set-cluster", "test-cluster", "--insecure-skip-tls-verify=true", "--server", apiUrl, "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig"), 0, false, true);
        Exec.exec(null, Arrays.asList("kubectl", "config", "set-context", "test-context", "--user", "test-user", "--cluster", "test-cluster", "--namespace", "default", "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig"), 0, false, true);
        Exec.exec(null, Arrays.asList("kubectl", "config", "use-context", "test-context", "--kubeconfig", TestFrameEnv.USER_PATH + "/test.kubeconfig"), 0, false, true);
    }
}

